////////////////////////////////////////////////////////////////////// 
// collect-simwalk2/Core.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "Core.h"
#include "HaploVector.h"

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

void ScanSummaryFiles(HaploSummaryTable & hst)
   {
   printf("Scanning Summary Tables\n");

   hst.run = 0;
   FILE * f;
   char name[20], goodname[20];

   goodname[0] = 0;

   while (1)
      {
      sprintf(name, "TABLE-%02d.ALL", ++hst.run);

      printf("Checking file %s\n", name);

      f = fopen(name, "rt");
      if (f == NULL)
         break;

      strcpy(goodname, name);

      fclose(f);
      }

   hst.run--;

   if (goodname[0])
      {
      printf("\nLoading run summary from file %s\n\n", goodname);
      f = fopen(goodname, "rt");
      hst.AppendFile(f);
      fclose(f);
      }
   else
      {
      printf("ERROR - No SimWalk Summary Tables found");
      abort();
      }

   hst.PrintStats();
   }

void ScanSimwalkFiles(HaploSummaryTable & hst)
   {
   char        name[20];
   int         fileCount = 0;
   int         missCount = 0;
   int         haploCount = 0;
   HaploVector hv;

   printf("Reading Simwalk HAPLO-nn.nnn files\n\n");

   FILE * out = fopen ("HAPLO.LST", "wt");

   for (int i = 0; i < hst.count; i++)
      if (hst.hs[i].IsUseful())
         {
         FILE * f = fopen ( hst.hs[i].MakeFileName( name ), "rt" );

         if (f == NULL)
            {
            printf("WARNING - Couldn't open file %s\n", name);
            missCount++;
            }
         else
            {
            fileCount ++;
            if (hv.LoadSimwalkFile(f, hst.hs[i].id) == 0)
               printf("There was a problem parsing file %s", name);
            else
               haploCount += hv.WriteToFile(out);
            fclose (f);
            }
         }

   fclose ( out );

   printf ("Processed %d haplotypes in %d files\n", haploCount, fileCount);
   if (missCount) printf ("(%d files were missing)\n", missCount);
   printf ("\n");
   }
 
