////////////////////////////////////////////////////////////////////// 
// collect-simwalk2/HaploSum.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "HaploSum.h"
#include "StringArray.h"

#include "string.h"
#include "stdio.h"
#include "ctype.h"

bool HaploSummary::all = 0;

HaploSummary::HaploSummary()
   {
   run[0] = serial[0] = id[0] = isGood = 0;
   total = recomb[0] = recomb[1] = recomb[2] = recomb[3]
         = recomb[4] = recomb[5] = 0;
   llk = 0;
   }

HaploSummary & HaploSummary::operator = (HaploSummary & rhs)
   {
   strcpy(run, rhs.run);
   strcpy(serial, rhs.serial);
   strcpy(id, rhs.id);
   llk = rhs.llk;
   total = rhs.total;
   for (int i=0; i < 6; i++)
      recomb[i] = rhs.recomb[i];
   isGood = rhs.isGood;

   return *this;
   }

int HaploSummary::LoadFile ( FILE * f, HaploSummary * table,
                             int tableSize, int newRun)
   {
   StringArray  lines;
   char check;

   lines.Read(f);

   int tablePos = 0;
   HaploSummary hs;

   int index = HT_SKIP_LINES;

   StringArray tokens;
   tokens.AddTokens(lines[3]);

   double swVersion = (double) tokens[tokens.Length() - 1];
   int sw260 = swVersion >= 2.56;

   printf("Simwalk Version = %.2f\n\n", swVersion);

   if (swVersion != 2.52 && (swVersion > 2.60 || swVersion < 2.56))
      printf("WARNING - Program not tested with this Simwalk2 Version!\n\n");

   while (tablePos < tableSize)
      {
      hs.run[0] = 0;
      hs.recomb[4] = hs.recomb[5] = -1;

      check = 0;

      if (sw260)
         sscanf(lines[index++], " %s %s %s %*s %lf %*s %d %d %d %d %d %d %c",
            hs.run, hs.serial, hs.id, &hs.llk, &hs.total,
            &hs.recomb[0], &hs.recomb[1], &hs.recomb[2], &hs.recomb[3],
            &hs.recomb[4], &check, hs.recomb[5] = 0);
      else
         sscanf(lines[index++], " %s %s %s %*s %lf %d %d %d %d %d %d %d %c",
            hs.run, hs.serial, hs.id, &hs.llk, &hs.total,
            &hs.recomb[0], &hs.recomb[1], &hs.recomb[2], &hs.recomb[3],
            &hs.recomb[4], &hs.recomb[5], &check);

      hs.isGood = (check == 0);
      if (!isdigit(hs.run[0]) || hs.recomb[4] == -1 || hs.recomb[5] == -1)
         break;

      sprintf(hs.run, "%02d", newRun);
      table[tablePos++] = hs;
      }

   return tablePos;
   }

char * HaploSummary::MakeFileName(char * name)
   {
   sprintf(name, "HAPLO-%s.%s", run, serial);
   return name;
   }

HaploSummaryTable::HaploSummaryTable(int s)
   {
   run = count = 0;
   size = s;
   hs = new HaploSummary[size];
   }

HaploSummaryTable::~HaploSummaryTable()
   {
   delete[] hs;
   }

int HaploSummaryTable::LoadFile(FILE * f)
   {
   count = 0;
   return AppendFile(f);
   }

int HaploSummaryTable::AppendFile(FILE * f)
   {
   count += HaploSummary::LoadFile(f, &hs[count], size - count, run);

   if (!(count < size))
      printf("\nWARNING maximum table size %d reached\n"
            "Extra haplotypes may have been ignored\n\n", size);

   return count;
   }

void HaploSummaryTable::PrintStats()
   {
   int info = 0;
   int empty = 0;
   int discard = 0;

   for (int i=0; i < count; i++)
      {
      if (hs[i].IsEmpty())
         empty++;
      else if (hs[i].IsBest())
         info++;
      else discard++;
      }

   printf("Summary statistics\n");
   printf("    %4d Families Haplotyped\n", count);
   printf("    %4d Solution Vectors Found\n", info);
   printf("    %4d Empty Vectors\n", empty);
   printf("    %4d need Refining by SimWalk\n\n", discard);
   }

 
