////////////////////////////////////////////////////////////////////// 
// collect-simwalk2/HaploSum.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef _HAPLOSUM_H_
#define _HAPLOSUM_H_

#include "Constant.h"
#include "stdio.h"

class HaploSummary
   {
   public:
      static bool    all;

      char     run[4], serial[8], id[8];
      double   llk;
      int      total;
      int      recomb[6];
      bool     isGood;

      // constructor
      HaploSummary();

      // operators
      HaploSummary & operator = (HaploSummary & rhs);

      // utility functions
      static int LoadFile ( FILE * f, HaploSummary * table,
                            int tableSize, int newRun);

      int IsEmpty()
         { return (total + recomb[0]) == 0; }
      int IsBest()
         { return isGood; };
      int IsUseful()
         { return (IsBest() || all) && (!IsEmpty()); }
      char * MakeFileName (char * name);
   };

class HaploSummaryTable
   {
   public:
      HaploSummary * hs;
      int            run;
      int            count;
      int            size;

      // constructor
      HaploSummaryTable(int s = HT_TABLE_SIZE);

      // destructor
      ~HaploSummaryTable();

      // utility functions
      int LoadFile( FILE * f);
      int AppendFile ( FILE * f);
      void PrintStats();
   };

#endif
 
