////////////////////////////////////////////////////////////////////// 
// collect-simwalk2/HaploVector.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef _HAPLOVECTOR_H_
#define _HAPLOVECTOR_H_

#include "Constant.h"
#include "StringBasics.h"
#include "IntArray.h"

#include "stdio.h"
#include "string.h"

class hvEntry
   {
   public:
      String name;
      IntArray states;

   hvEntry() : name("")
      { }

   ~hvEntry()
      { }

   static int Compare(hvEntry * one, hvEntry * two);
   char * AsString(int * filter);
   };

class HaploVector
   {
   public:
      static int maxHaplotypes;

      hvEntry * entries;
      int  size;
      int  count;       // number of haplotypes stored
      int  length;      // number of markers in each haplotype

   // constructor
   HaploVector(int s = 0);

   // destructor
   ~HaploVector()
      {
      delete [] entries;
      }

   // Utility functions
   void Empty()
      { count = 0; length = 0; }

   // File access functions
   int LoadSimwalkFile(FILE * f, const char * label = NULL)
      {
      Empty();
      return AppendSimwalkFile(f, label);
      }

   int AppendSimwalkFile(FILE * f, const char * label = NULL);

   int WriteToFile(FILE * f) const;

   void Sort();
   hvEntry * Find(char * name);
   };

#endif
 
