////////////////////////////////////////////////////////////////////// 
// collect-simwalk2/collect-simwalk2.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "HaploSum.h"
#include "Core.h"

#include "stdio.h"
#include "string.h"

int main(int argc, char * argv[])
   {
   printf("collect-simwalk2 1.1 - Collect Simwalk2 founder haplotype estimates\n"
          "(c) 1998 - 2001 Goncalo Abecasis\n\n"
          "Use after running setup-simwalk2 to configure a Simwalk2 run,\n"
          "and running simwalk2 to estimate haplotypes.\n\n"
          "Option: [-a] include all haplotype estimates.\n\n");

   if (argc > 1)
      if (strcmp(argv[1], "a") == 0 ||
          strcmp(argv[1], "A") == 0 ||
          strcmp(argv[1], "-a") == 0 ||
          strcmp(argv[1], "-A") == 0 )
      HaploSummary::all = 1;

   HaploSummaryTable hst;
   ScanSummaryFiles(hst);
   ScanSimwalkFiles(hst);
   } 
