////////////////////////////////////////////////////////////////////// 
// haploxt/AssocLD.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "AssocLD.h"
#include "MathVector.h"

#include "math.h"

#define _MIN_(a,b)   ( (x=(a)) < (y=(b)) ? x : y)

void AssocLD::Calc(int ** nn, int ni, int nj)
   {
   isValid = false;

   Vector sumi(ni), sumj(nj);
   double sum = 0.0;

   sumi.Zero();
   sumj.Zero();

   D = Dmax = standardD = 0;

   for (int i = 0; i <  ni; i++)
      for (int j = 0; j < nj; j++)
         {
         sumi[i] += nn[i][j];
         sumj[j] += nn[i][j];
         sum += nn[i][j];
         }

   double _D, _Dmax, expected;

   double x, y;

   if (sum != 0)
      {
      for (int i = 0; i < ni; i++)
      for (int j = 0; j < nj; j++)
         {
         if (sumi[i] == 0 || sumj[j] == 0) continue;

         expected = sumi[i] * sumj[j] / sum;
         _D = (nn[i][j] - expected);

         if (fabs(_D) < 1e-10) continue;
         if (_D < 0)
            _Dmax = _MIN_(sumi[i]*sumj[j], (sum - sumi[i])*(sum - sumj[j]));
         else
            _Dmax = _MIN_(sumi[i]*(sum - sumj[j]), (sum - sumi[i])*sumj[j]);
         standardD += sumi[i] * sumj[j] * fabs(_D) / _Dmax;
         D += sumi[i] * sumj[j] * fabs(_D) / (sum * sum * sum);
         }

      standardD /= sum;
      isValid = true;
      }
   }

 
