////////////////////////////////////////////////////////////////////// 
// haploxt/HaploVector.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef _HAPLOVECTOR_H_
#define _HAPLOVECTOR_H_

#include "StringArray.h"
#include "IntArray.h"
#include "Constant.h"

#include "stdio.h"

class HaploVector
   {
   public:
      StringArray names;
      IntArray * states;
      int  size;
      int  count;       // number of haplotypes stored
      int  length;      // number of markers in each haplotype
         
   // constructor
   HaploVector(int s = HV_MAXSIZE);
   
   // destructor
   ~HaploVector();
   
   // Utility functions
   void Empty()
      { count = 0; length = 0; }
      
   void PrintStats();

   int IsUseful(int i);
   
   // File access functions
   int LoadSimwalkFile(FILE * f, const char * label = NULL)
      {
      Empty();
      return AppendSimwalkFile(f, label);
      }
      
   int AppendSimwalkFile(FILE * f, const char * label = NULL);
   
   int ReadFromFile(FILE * f);
   int WriteToFile(FILE * f) const;

   private:
      IntArray cache;
   };
   
extern int haploTresh;

#endif 
