////////////////////////////////////////////////////////////////////// 
// haploxt/Main.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "Core.h"
#include "HaploVector.h"
#include "Parameters.h"

#include "stdlib.h"

int maxHaplos = XT_VECTORSIZE;
int poolTresh = XT_POOLTRESH;
bool verbose = 0;
bool smallPools = 1;

int main(int argc, char ** argv)
   {
   printf("HaploXT 1.1 - Crosstabulates states from marker haplotypes\n");
   printf("(c) 1998-2001 Goncalo Abecasis\n\n");

   ParameterList pl;
   pl.Add(new IntParameter('q', "Quality Threshold (%)", haploTresh));
   pl.Add(new IntParameter('p', "Pooling Threshold (%)", poolTresh));
   pl.Add(new IntParameter('m', "Maximum Haplotypes", maxHaplos));
   pl.Add(new SwitchParameter('v', "Verbose Mode", verbose));
   pl.Add(new SwitchParameter('s', "Analyse Small Pools", smallPools));
   pl.Read(argc, argv);
   pl.Status();

   HaploVector hv(maxHaplos);

   ScanHaplotypes(hv);
   CrossTabAll(hv);

   return 0;
   }
 
