////////////////////////////////////////////////////////////////////// 
// ldmax/Interface.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "Parameters.h"
#include "LdMax.h"

int main(int argc, char ** argv)
   {
   ParameterList pl;

   printf("LDMAX -- Maximum likelihood estimates of pairwise disequilibrium\n"
          "(c) 1999-2001 Goncalo Abecasis\n\n");

   String pedigreeFile(QTDTPED), mapFile ("map.gm"), dataFile;
   double pool = 0.1;
   bool   foundersOnly = 1;
   bool   verbose = 0;

   pl.Add(new StringParameter('p', "Pedigree File", pedigreeFile));
   pl.Add(new StringParameter('m', "Map File", mapFile));
   pl.Add(new SwitchParameter('f', "Founders Only", foundersOnly));
   pl.Add(new DoubleParameter('t', "Pooling Treshold", pool));
   pl.Add(new SwitchParameter('v', "Verbose Output", verbose));
   pl.Add(new HiddenString('d', "Data File", dataFile));

   pl.Read(argc, argv);
   pl.Status();

   Pedigree ped;

   if (dataFile.IsEmpty())
      ped.pd.LoadMap(mapFile);
   else
      ped.Prepare(dataFile);
   ped.Load(pedigreeFile);
   ped.LumpAlleles(pool);

   LDMax engine;
   IntArray markers;

   markers.Dimension(2);
   engine.foundersOnly = foundersOnly;

   FILE * output = fopen("LD.XT", "wt");
   if (output == NULL)
      printf("WARNING - Error opening file LD.XT for output\n");

   printf("   M1   M2 al1 al2     N df(0) df(1)   ChiSq  pvalue delta2    D'\n");

   if (output != NULL)
      fprintf(output,
      "   M1   M2 al1 al2     N df(0) df(1)   ChiSq  pvalue delta2    D'\n");

   for (markers[0] = 0; markers[0] < Person::markerCount; markers[0]++)
   for (markers[1]=markers[0]+1; markers[1] < Person::markerCount; markers[1]++)
       {
       if (!engine.SelectMarkers(markers, ped)) continue;
       engine.TheWorks();

       printf("%5d%5d%4d%4d %5d %5d %5d %7.2f %7.5f  %5.3f %5.3f\n",
             markers[0]+1, markers[1]+1, engine.nAlleles[0], engine.nAlleles[1],
             engine.count, engine.dfNull, engine.dfFull, engine.ChiSq,
             engine.pvalue, engine.deltasq, engine.Dprime);

       if (output != NULL)
             fprintf(output,
             "%5d%5d%4d%4d %5d %5d %5d %7.2f %7.5f  %5.3f %5.3f\n",
             markers[0]+1, markers[1]+1, engine.nAlleles[0], engine.nAlleles[1],
             engine.count, engine.dfNull, engine.dfFull, engine.ChiSq,
             engine.pvalue, engine.deltasq, engine.Dprime);

       IntArray haplo(2);

       if (verbose)
         for (haplo[0]=1; haplo[0]<=ped.CountAlleles(markers[0]); haplo[0]++)
            for (haplo[1]=1; haplo[1]<=ped.CountAlleles(markers[1]); haplo[1]++)
               printf("       Haplotype: %2d - %2d    ML Freq: %.3f, Null Freq: %.3f\n",
                  haplo[0], haplo[1],
                  engine.estimates[engine.HaplotypeIndex(haplo)],
                  engine.defaults[engine.HaplotypeIndex(haplo)]);
       }

   if (output != NULL) fclose(output);
   }
 
