////////////////////////////////////////////////////////////////////// 
// ldmax/LdMax.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef __LDMAX_H__
#define __LDMAX_H__

#include "IntArray.h"
#include "MathVector.h"
#include "Pedigree.h"

class LDMax
   {
   public:
      Vector   * alleleFrequencies, haplotypeFrequencies, genotypeFrequencies;

      IntArray * haplotypeList1, * haplotypeList2;
      IntArray   haplotype1, haplotype2, genotype, genotypeCounts;
      IntArray   markers;
      IntArray   nAlleles, nGenotypes;

      int  foundersOnly;
      int  nloci;
      long nhaplo, ngeno, count;

      LDMax();
      ~LDMax();

      bool SelectMarkers(const IntArray & markers, Pedigree & ped);

      bool isGenotyped(Person & i);
      void GetGenotype(Person & i);
      void GetGenotype();

      int  GenotypeIndex();
      int  HaplotypeIndex(IntArray & haplo);

      void   ResetHaplotype(IntArray & haplo);
      bool   isLastHaplotype(IntArray & haplo);
      bool   IncrementHaplotype(IntArray & haplo);

      void   GetHaplotype(IntArray & haplo, int number);
      double NullFreq(IntArray & haplo);
      void   NullFrequencies();

      void   UpdateGenotypeFrequencies();
      void   UpdateHaplotypeFrequencies();

      double LogLikelihood();
      void   Maximize();

      // Useful summaries
      Vector defaults, estimates;
      double logLKfull, logLKnull, ChiSq, pvalue, Dprime, D, deltasq;
      int    dfNull, dfFull;

      void TheWorks();
   };

#endif 
