////////////////////////////////////////////////////////////////////// 
// libsrc/IntArray.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "IntArray.h"
#include "Sort.h"

#include <string.h>

int IntArray::alloc = 4;

IntArray::IntArray(int start_size)
   {
   count = start_size;
   size = (count + alloc) / alloc * alloc;
   items = new int [size];
   }

IntArray::IntArray(IntArray & source)
   {
   count = source.count;
   size = source.size;
   items = new int [size];

   for (int i = 0; i < count; i++)
      items[i] = source.items[i];
   }

IntArray::~IntArray()
   {
   delete [] items;
   }

void IntArray::Grow(int new_size)
   {
   if (new_size > size)
      {
      size = (new_size + alloc) / alloc * alloc;
      int * new_items = new int [size];
      for (int i = 0; i < count; i++)
         new_items[i] = items[i];
      delete [] items;
      items = new_items;
      }
   }

int IntArray::Append(int value)
   {
   Grow(count + 1);
   items[count++] = value;
   return count;
   }

void IntArray::Set(int value)
   {
   for (int i = 0; i < count; i++)
      items[i] = value;
   }

void IntArray::SetSequence(int start, int increment)
   {
   for (int i = 0; i < count; i++, start += increment)
      items[i] = start;
   }

int IntArray::Delete(int index)
   {
   count--;
   if (count - index)
      memmove(items + index, items + index + 1, sizeof(int) * (count - index));
   return count;
   }

void IntArray::InsertAt(int index, int value)
   {
   Grow(count + 1);
   memmove(items + index + 1, items + index, sizeof(int) * (count - index));
   items[index] = value;
   count++;
   }

IntArray & IntArray::operator = (const IntArray & rhs)
   {
   Grow(rhs.count);
   count = rhs.count;
   for (int i = 0; i < count; i++)
      items[i] = rhs.items[i];
   return *this;
   }

int IntArray::Sum(int start, int end) const
   {
   int result = 0;

   for (int i = start; i <= end; i++)
      result += items[i];

   return result;
   }

int IntArray::Find(int value) const
   {
   for (int i = 0; i < count; i++)
      if (value == items[i])
         return i;
   return -1;
   }

void IntArray::Zero()
   {
   for (int i = 0; i < count; i++)
      items[i] = 0;
   }

int IntArray::Compare(int * a, int * b)
   { return *a - *b; }

void IntArray::Sort()
   {
   QuickSort(items, count, sizeof(int), COMPAREFUNC Compare);
   }

void IntArray::Reverse()
   {
   for (int i = 0, j = count - 1; i < j; i++, j--)
      Swap(i, j);
   }

int IntArray::CountIfGreater(int treshold) const
   {
   int result = 0;

   for (int i = 0; i < count; i++)
      if (items[i] > treshold)
         result++;

   return result;
   }

int IntArray::CountIfGreaterOrEqual(int treshold) const
   {
   int result = 0;

   for (int i = 0; i < count; i++)
      if (items[i] > treshold)
         result++;

   return result;
   }

void IntArray::Add(int term)
   {
   for (int i = 0; i < count; i++)
      items[i] += term;
   }

void IntArray::Multiply(int factor)
   {
   for (int i = 0; i < count; i++)
      items[i] *= factor;
   }

void IntArray::Divide(int denominator)
   {
   for (int i = 0; i < count; i++)
      items[i] /= denominator;
   }
   
void IntArray::Stack(const IntArray & a)
   {
   int end = count;

   Dimension(count + a.count);

   for (int i = 0; i < a.count; i++)
      items[i + end] = a[i];
   }


 
