////////////////////////////////////////////////////////////////////// 
// libsrc/IntArray.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef __INTARRAY_H__
#define __INTARRAY_H__

class IntArray
   {
   private:
      int * items;
      int size, count;

      void Grow(int new_size);
      static int Compare(int * a, int * b);

   public:
      static int alloc;

      IntArray(int start_size = 0);
      IntArray(IntArray & source);
      ~IntArray();

      IntArray & operator = (const IntArray & rhs);

      int & operator [] (int index) { return items[index]; }
      int   operator [] (int index) const { return items[index]; }

      int  Append(int value);
      void Push(int value)          { Append(value); }
      int  Pop()                    { return items[--count]; }
      int  Peek() const             { return items[count - 1]; }
      int &Last() const             { return items[count - 1]; }

      int  Delete(int index);
      void InsertAt(int index, int value);

      int  Find(int value) const;
      void Sort();

      void Zero();
      void Set(int value);
      void SetSequence(int start = 0, int increment = 1);

      int  Length() const           { return count; }
      void Dimension(int new_count) { Grow(new_count); count = new_count; }
      void Clear()                  { count = 0; }

      int  Sum() const              { return Sum(0, count - 1); }
      int  Sum(int start) const     { return Sum(start, count - 1); }
      int  Sum(int start, int end) const;

      int  Count() const            {return count; }
      int  CountIfGreater(int treshold) const;
      int  CountIfGreaterOrEqual(int treshold) const;

      void Swap(int i, int j)
           { int tmp = items[i]; items[i] = items[j]; items[j] = tmp; }

      void Reverse();

      operator int * ()               { return items; }

      void Add(int term);
      void Subtract(int term) { Add(-term); }
      void Multiply(int factor);
      void Divide(int denominator);

      IntArray & operator += (int rhs)
         { Add(rhs); return *this; }

      IntArray & operator *= (int rhs)
         { Multiply(rhs); return *this; }

      IntArray & operator -= (int rhs)
         { Add(-rhs); return *this; }

      IntArray & operator /= (int rhs)
         { Divide(rhs); return *this; }

      void Stack(const IntArray & rhs);
   };

#endif


 
