////////////////////////////////////////////////////////////////////// 
// libsrc/MapFunction.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "MapFunction.h"
#include "MathConstant.h"

#include <math.h>

double DistanceToRecombination(double distance)
   {
   return (1.0 - exp(-2.0 * distance)) * 0.5;
   }

double RecombinationToDistance(double recombination)
   {
   return (log(max(1.0 - 2 * recombination, 1e-7)) * -0.5);
   }


 
