////////////////////////////////////////////////////////////////////// 
// libsrc/Parameters.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef __PARAMETERS_H__
#define __PARAMETERS_H__

#include "StringMap.h"

#include <ctype.h>
#include <stddef.h>

class ParameterList;

class Parameter
   {
   protected:
      char ch;
      char * description;
      void * var;

      static int nameCol;
      static int statusCol;

      virtual void Translate(const char * value) = 0;

   public:

      Parameter(char c, const char * desc, void * v);

      virtual ~Parameter()
         {
         delete [] description;
         }

      virtual bool Read(int argc, char ** argv, int argn);
      virtual void Status() = 0;

      static void SetNameLen(int len) { nameCol = len; }
      static void SetStatusLen(int len) { statusCol = len; }

      friend class ParameterList;
   };

class IntParameter : public Parameter
   {
   public:
      IntParameter(char c, const char * desc, int & v)
         : Parameter(c, desc, &v)
         {}

      virtual void Status();

   protected:
      virtual void Translate(const char * value);
   };

class HiddenInteger : public IntParameter
   {
   public:
      HiddenInteger(char c, const char * desc, int & v)
         : IntParameter(c, desc, v)
         {}

      virtual void Status() { }
   };


class SwitchParameter : public Parameter
   {
   public:
      SwitchParameter(char c, const char * desc, bool & v)
         : Parameter(c, desc, &v)
         {}

      virtual void Status();

   protected:
      virtual void Translate(const char * value);
   };

class HiddenSwitch : public SwitchParameter
   {
   public:
      HiddenSwitch(char c, const char * desc, bool & v)
         : SwitchParameter(c, desc, v)
         {}

      virtual void Status() { }
   };

class DoubleParameter : public Parameter
   {
   public:
   DoubleParameter(char c, const char * desc, double & v)
      : Parameter(c, desc, &v)
      {}

   virtual void Status();

   protected:
      virtual void Translate(const char * value);
   };


class StringParameter : public Parameter
   {
   public:
   StringParameter(char c, const char * desc, String & v)
      : Parameter(c, desc, &v) {}

   virtual void Status();

   protected:
      virtual void Translate(const char * value);
   };

class HiddenString : public StringParameter
   {
   public:
      HiddenString(char c, const char * desc, String & v)
         : StringParameter(c, desc, v)
         {}

      virtual void Status() { }
   };

struct OptionList
   {
   char     ch;
   char *   description;
   int      code;
   };

#define BEGIN_OPTION_LIST(name)     ; OptionList name[] = {
#define END_OPTION_LIST(none)       , {0, none, 0} };

class ListParameter : public Parameter
   {
   public:
   ListParameter(char c, const char * desc, int & v, OptionList * opt);

   virtual void Status();

   protected:
      String       key;
      OptionList * options;
      virtual void Translate(const char * value);
   };

class SetParameter : public Parameter
   {
   public:
   SetParameter(char c, const char * desc, int & v, OptionList * opt);

   virtual void Status();

   protected:
      String       key;
      OptionList * options;
      virtual void Translate(const char * value);
   };

struct LongParameterList
   {
   char * description;
   void * value;
   bool exclusive;
   int  type;
   };

#define LP_BOOL_PARAMETER     1
#define LP_INT_PARAMETER      2

#define BEGIN_LONG_PARAMETERS(array)   LongParameterList array[] = {\
                                            { NULL,  NULL,    false, 0 },
#define LONG_PARAMETER_GROUP(label)         { label, NULL,    false, 0 },
#define LONG_PARAMETER(label,boolptr)       { label, boolptr, false, 1 },
#define EXCLUSIVE_PARAMETER(label,boolptr)  { label, boolptr, true , 1 },
#define LONG_INTPARAMETER(label,intptr)     { label, intptr,  true,  2 },
#define END_LONG_PARAMETERS()               { NULL,  NULL,    false, 0 }};

class LongParameters : public Parameter
   {
   public:
      LongParameters(const char * desc, LongParameterList * list);

      virtual void Status();

   protected:
      StringMap index;
      LongParameterList * list;
      int group_len;

      virtual void Translate(const char * value);
   };

class ParameterList
   {
   protected:
      Parameter ** pl;
      int count;
      int size;

      void MakeString(int argc, char ** argv, int start = 1);

   public:
      char * string;

      ParameterList(int s = 36)
         {
         size = s;
         count = 0;
         pl = new Parameter * [size];
         string = NULL;
         }

      virtual ~ParameterList();

      void Add(Parameter * p);

      // Tries to process all command line arguments
      virtual void Read(int argc, char ** argv, int start = 1);

      // Allows for trailing, unprocessed, filenames in the command line
      // The number of translated argv[] items is returned
      virtual int ReadWithTrailer(int argc, char ** argv, int start = 1);

      // Outputs summary of parameter switches and settings
      virtual void Status();
   };

#endif
 
