////////////////////////////////////////////////////////////////////// 
// libsrc/Pedigree.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef _PEDIGREE_H_
#define _PEDIGREE_H_

#include "Constant.h"

#include <stdio.h>

#include "PedigreeAlleles.h"
#include "PedigreePerson.h"
#include "PedigreeGlobals.h"
#include "PedigreeFamily.h"
#include "PedigreeDescription.h"
#include "PedigreeAlleleFreq.h"

class Pedigree : public PedigreeGlobals
   {
   public:
      static int           writeHalves;
      static String        missing;

      PedigreeDescription  pd;
      int                  size;
      int                  count;
      Person **            persons;
      int                  familyCount;
      Family **            families;
      int                  haveTwins;

   Pedigree();
   ~Pedigree();

   void Prepare(FILE * input);      // Read pedigree parameters from data file
   void Load(FILE * input);         // Read pedigree from pedigree file
   void Prepare(const char * input);// Read pedigree parameters from named file
   void Load(const char * input);   // Read pedigree parameters from named file

   void PrepareDichotomization();   // Register dummy affections for each trait
   int  Dichotomize(int trait, double mean = _NAN_);
   void DichotomizeAll(double mean = _NAN_);

   void WriteDataFile(FILE * output);           // Write data file
   void WritePedigreeFile(FILE * output);       // Write pedigree file
   void WriteDataFile(const char * output);     // Write named data file
   void WritePedigreeFile(const char * output); // Write named pedigree file
   void WritePerson(FILE * output, int who);    // Write a single person
   void WritePerson(FILE * output, int who,     // the second version allows
        const char * famid, const char * pid,   // individuals and families to
        const char * fatid, const char * motid);// be renamed / restructured

   void Sort();                              // Sorts the pedigree items
   Family * FindFamily(const char * famid);  // Find a family
   Person * FindPerson(const char * famid,   // Find an individual
                       const char * pid);

   // functions dealing with genetic markers
   int  CountAlleles(int marker);           // Counts the alleles at a marker
   void LumpAlleles(double treshold);       // Lumps together rare alleles
   void EstimateFrequencies(int estimator); // Calculate allele frequencies

   // shorthand operators
   Person & operator [] (int i)
      {
      return *(persons[i]);
      }

   // Perform a basic inheritance check
   void InheritanceCheck();
   void TwinCheck();

   // Merge twins into a single individual
   void MergeTwins();

   private:
      void Grow();
      static int ComparePersons(const Person ** p1, const Person ** p2);
      static int CompareParents(const Person ** p1, const Person ** p2);

      void MakeSibships();
      void MakeFamilies();

      Person * FindPerson(const char * famid, const char * pid, int universe);
   };

#endif


 
