////////////////////////////////////////////////////////////////////// 
// libsrc/PedigreeFamily.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "Pedigree.h"
#include "Constant.h"
#include "MathConstant.h"
#include "Error.h"

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <limits.h>

Family::Family(Pedigree & pedigree, int _first, int _last, int _serial)
   {
   serial = _serial;
   first = _first;
   last = _last;
   ped = &pedigree;
   count = last - first + 1;
   path = new int [count];
   famid = (*ped)[first].famid;

   founders = mzTwins = 0;

   for (int i=first; i<=last; i++)
      if ((*ped)[i].isFounder())
         {
         (*ped)[i].traverse = founders;
         path[founders++] = (*ped)[i].serial;
         }
      else
         {
         (*ped)[i].traverse = -1;
         if ( (*ped)[i].isMzTwin((*ped)[i]))
            for (int j = first; j < i; j++)
               if ((*ped)[i].isMzTwin( (*ped)[j] ))
                  {
                  mzTwins++;
                  break;
                  }
         }

   nonFounders = count - founders;
   generations = nonFounders == 0 ? 1 : 2;

   int next = founders;
   while (next < count)
      {
      bool check = false;

      // Create traversal where path ancestors precede their offspring
      for (int i=first; i<=last; i++)
         if ((*ped)[i].traverse == -1)
            {
            int fatherSerial = (*ped)[i].father->traverse;
            int motherSerial = (*ped)[i].mother->traverse;

            if (fatherSerial >= 0 && motherSerial >= 0)
               {
               check = true;

               ped->persons[i]->traverse = next;
               path[next++] = i;

               if (fatherSerial >= founders || motherSerial >= founders)
                  generations = 3;
               }
            }

      if (!check)
         error("The structure of family %s requires\n"
               "an individual to be his own ancestor.\n",
               (const char *) famid);
      }
   }

Family::~Family()
   {
   delete [] path;
   }


 
