////////////////////////////////////////////////////////////////////// 
// libsrc/PedigreeGlobals.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef __PEDGLOBALS_H__
#define __PEDGLOBALS_H__

#include "Constant.h"
#include "StringArray.h"
#include "StringMap.h"
#include "IntArray.h"
#include "MathVector.h"

class MarkerInfo
   {
   public:
      int    chromosome;
      double position;
      Vector freq;
      String name;

   MarkerInfo(String & string)
      {
      name = string;
      chromosome = -1;
      position = 0.0;
      }

   static int ComparePosition(MarkerInfo ** left, MarkerInfo ** right);
   };

class PedigreeGlobals
   {
   public:
      static int traitCount;
      static int markerCount;
      static int affectionCount;
      static int covariateCount;

      static StringArray traitNames;
      static StringArray covariateNames;
      static StringArray affectionNames;
      static StringArray markerNames;
      static StringMap   markerLookup;

      static int GetTraitID(const char * name);
      static int GetMarkerID(const char * name);
      static int GetCovariateID(const char * name);
      static int GetAffectionID(const char * name);
      static int LookupMarker(const char * name)
         { return markerLookup.Integer(name); }

      static int markerInfoCount;
      static int markerInfoSize;
      static MarkerInfo ** markerInfo;

      static void GrowMarkerInfo();
      static MarkerInfo * GetMarkerInfo(String & name);
      static MarkerInfo * GetMarkerInfo(int marker)
         { return GetMarkerInfo(markerNames[marker]); }

      static int SortMarkersInMapOrder(IntArray & markers, int chromosome = -1);

      static void LoadAlleleFrequencies(const char * filename);
      static void LoadAlleleFrequencies(FILE * file);

      static void LoadMarkerMap(const char * filename);
      static void LoadMarkerMap(FILE * file);

      static void WriteMapFile(const char * filename);
      static void WriteMapFile(FILE * file);

      static void WriteFreqFile(const char * filename);
      static void WriteFreqFile(FILE * file);

      PedigreeGlobals() { instanceCount++; }
      ~PedigreeGlobals();

   private:
      static int  instanceCount;
   };

#endif
 
