////////////////////////////////////////////////////////////////////// 
// libsrc/PedigreePerson.cpp 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#include "PedigreePerson.h"
#include "Constant.h"
#include "StringArray.h"
#include "Error.h"

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <limits.h>

Person::Person()
   {
   zygosity = sex = 0;
   serial = traverse = -1;

   markers = new Alleles [markerCount];
   traits = new double [traitCount];
   covariates = new double [covariateCount];
   affections = new int [affectionCount];

   for (int i = 0; i < traitCount; i++) traits[i] = _NAN_;
   for (int i = 0; i < covariateCount; i++) covariates[i] = _NAN_;
   for (int i = 0; i < affectionCount; i++) affections[i] = 0;

   father = mother = NULL;
   sibs = NULL;
   sibCount = 0;

   ngeno = 0;
   hasBothParents = hasAllTraits = hasAllAffections = hasAllCovariates = false;
   }

Person::~Person()
   {
   delete [] markers;
   delete [] traits;
   delete [] affections;
   delete [] covariates;

   if (sibCount) delete [] sibs;
   }

void Person::AssessStatus()
   {
   hasBothParents = father != NULL && mother != NULL;

   if (!hasBothParents && (father != NULL || mother != NULL))
       error ("Only one parent available for Person %s in Family %s",
              (const char *) pid, (const char *) famid);

   hasAllTraits = hasAllAffections = hasAllCovariates = true;

   ngeno = 0;
   for (int m = 0; m < markerCount; m++)
      if (isGenotyped(m))
         ngeno++;

   for (int t = 0; t < traitCount; t++)
      if (!isPhenotyped(t))
         {
         hasAllTraits = false;
         break;
         }

   for (int c = 0; c < covariateCount; c++)
      if (!isControlled(c))
         {
         hasAllCovariates = false;
         break;
         }

   for (int a = 0; a < affectionCount; a++)
   if (!isDiagnosed(a))
      {
      hasAllAffections = false;
      break;
      }
   }

void Person::Order(Person * & p1, Person * & p2)
   {
   if (p1->traverse > p2->traverse)
      {
      Person * temp = p1;
      p1 = p2;
      p2 = temp;
      }
   }

int Person::GenotypedMarkers()
   {
   int count = 0;

   for (int m = 0; m < Person::markerCount; m++)
      if (markers[m].isKnown())
         count++;

   return count;
   }





 
