////////////////////////////////////////////////////////////////////// 
// libsrc/PedigreePerson.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef __PEDPERSON_H__
#define __PEDPERSON_H__

#include "Constant.h"
#include "PedigreeAlleles.h"
#include "PedigreeGlobals.h"
#include "StringArray.h"
#include "IntArray.h"

class Person : public PedigreeGlobals
   {
   public:
      String      famid;
      String      pid;
      String      motid;
      String      fatid;
      int         sex;
      int         zygosity;
      int         serial, traverse;

      Alleles *   markers;
      double *    traits;
      int *       affections;
      double *    covariates;

      Person *    father;
      Person *    mother;

      int         sibCount;
      Person **   sibs;

      int         ngeno;

      Person();
      ~Person();

      bool isHalfSib(Person & sib)
         {
         return hasBothParents &&
            ((sib.father == father) ^ (sib.mother == mother));
         }

      bool isSib(Person & sib)
         {
         return hasBothParents &&
                (sib.father == father) && (sib.mother == mother);
         }

      bool isTwin(Person & twin)
         {
         return (zygosity != 0) && (zygosity == twin.zygosity) && isSib(twin);
         }

      bool isMzTwin(Person & mzTwin)
         {
         return (zygosity & 1) && (zygosity == mzTwin.zygosity) && isSib(mzTwin);
         }

      // Assess status before using quick diagnostics functions
      void AssessStatus();

      // Quick diagnostics
      bool isFounder()
         { return !hasBothParents; }
      bool isSexed()
         { return sex != 0; }
      bool isGenotyped(int m)
         { return markers[m].isKnown(); }
      bool isFullyGenotyped()
         { return ngeno == markerCount; }
      bool isControlled(int c)
         { return covariates[c] != _NAN_; }
      bool isFullyControlled()
         { return hasAllCovariates; }
      bool isPhenotyped(int t)
         { return traits[t] != _NAN_; }
      bool isFullyPhenotyped()
         { return hasAllTraits; }
      bool isDiagnosed(int a)
         { return affections[a] != 0; }
      bool isFullyDiagnosed()
         { return hasAllAffections; }

      int GenotypedMarkers();

      static void Order(Person * & p1, Person * & p2);

   private:
      bool hasAllCovariates, hasAllTraits,
           hasAllAffections, hasBothParents;
   };

#endif


 
