////////////////////////////////////////////////////////////////////// 
// libsrc/StringMap.h 
// (c) 2000-2001 Goncalo Abecasis
// 
// This file is distributed as part of the GOLD source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile GOLD.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Thursday November 08, 2001
// 
 
#ifndef __STRINGMAP_H__
#define __STRINGMAP_H__

#include "StringBasics.h"

class StringMap
   {
   protected:
      ::String ** strings;
      void     ** objects;
      int         count, size;

   public:
      static int alloc;

      StringMap(int startsize = 0);
      virtual ~StringMap();

      void Grow(int newsize);
      void Clear();
      int  Length() { return count; }

      void * Object(int i) { return objects[i]; }
      void * Object(const ::String & key)
         {
         int index = Find(key);
         return (index >= 0) ? objects[index] : NULL;
         }
      void * Object(const ::String & key, void * (*create_object)())
         { return objects[Find(key, create_object)]; }

      void SetObject(int i, void * object)
         { objects[i] = object; }
      void SetObject(const ::String & key, void * object)
         { Add(key, object); }

      int Integer(int i) { return (int) objects[i]; }
      int Integer(const ::String & key)
         {
         int index = Find(key);
         return (index >= 0) ? (int) objects[index] : -1;
         }

      void SetInteger(int i, int value)
         { objects[i] = (void *) value; }
      void SetInteger(const ::String & key, int value)
         { Add(key, (void *) value); }

      int Add(const ::String & s, void * object = NULL);
      int Find(const ::String & s, void * (*create_object)() = NULL);
      int FindStem(const ::String & stem);

      StringMap & operator = (const StringMap & rhs);

      ::String & operator [] (int i) { return *(strings[i]); }
      ::String & String(int i) { return *(strings[i]); }

      static void * CreateMap();

      int IncrementCount(const ::String & key);
      int DecrementCount(const ::String & key);
      int GetCount(const ::String & key);
      int GetCount(int index) { return (int) objects[index]; }

      void Delete(int index);
   };

#endif

 
