unit PrettyNumbers;

interface

type PrettyInteger = record
   input : int64;
   adjusted : int64;
   scale : int64;
   factor : int64;
end;

function RoundUp( i : integer) : PrettyInteger;

implementation

{ PrettyInteger }

function RoundUp(i: integer) : PrettyInteger;
var t : PrettyInteger;
begin
    with t do
    begin
       input := i;
       scale := 1;

       while true do
       begin
          factor := scale;
          if abs(input div factor) < 5 then break;
          factor := scale * 2;
          if abs(input div factor) < 5 then break;
          factor := scale * 4;
          if abs(input div factor) < 5 then break;
          factor := scale * 5;
          if abs(input div factor) < 5 then break;
          scale := scale * 10;
       end;

       adjusted := (input + factor - 1) div factor * factor;
    end;
    RoundUp := t;
end;

end.
