////////////////////////////////////////////////////////////////////// 
// libsrc/MemoryAllocators.cpp 
// (c) 2000-2008 Goncalo Abecasis
// 
// This file is distributed as part of the MaCH source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile MaCH.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Saturday April 12, 2008
// 
 
#include "MemoryAllocators.h"

#include <stdlib.h>

char *** AllocateCharCube(int n, int rows, int cols)
   {
   char *** cube = new char ** [n];

   // Stop early if we are out of memory
   if (cube == NULL)
      return NULL;

   for (int i = 0; i < n; i++)
      {
      cube[i] = AllocateCharMatrix(rows, cols);

      // Safely unravel allocation if we run out of memory
      if (cube[i] == NULL)
         {
         while (i--)
            FreeCharMatrix(cube[i], rows);

         delete [] cube;

         return NULL;
         }
      }

   return cube;
   }

int ** AllocateIntMatrix(int rows, int cols)
   {
   int ** matrix = new int * [rows];

   // Stop early if we are out of memory
   if (matrix == NULL)
      return NULL;

   for (int i = 0; i < rows; i++)
      {
      matrix[i] = new int [cols];

      // Safely unravel allocation if we run out of memory
      if (matrix[i] == NULL)
         {
         while (i--)
            delete [] matrix[i];

         delete [] matrix;

         return NULL;
         }
      }

   return matrix;
   }

char ** AllocateCharMatrix(int rows, int cols)
   {
   char ** matrix = new char * [rows];

   // Stop early if we are out of memory
   if (matrix == NULL)
      return NULL;

   for (int i = 0; i < rows; i++)
      {
      matrix[i] = new char [cols];

      // Safely unravel allocation if we run out of memory
      if (matrix[i] == NULL)
         {
         while (i--)
            delete [] matrix[i];

         delete [] matrix;

         return NULL;
         }
      }

   return matrix;
   }

float ** AllocateFloatMatrix(int rows, int cols)
   {
   float ** matrix = new float * [rows];

   // Stop early if we are out of memory
   if (matrix == NULL)
      return NULL;

   for (int i = 0; i < rows; i++)
      {
      matrix[i] = new float [cols];

      // Safely unravel allocation if we run out of memory
      if (matrix[i] == NULL)
         {
         while (i--)
            delete [] matrix[i];

         delete [] matrix;

         return NULL;
         }
      }

   return matrix;
   }

void FreeCharCube(char *** & cube, int n, int rows)
   {
   if (cube == NULL)
      return;

   for (int i = 0; i < n; i++)
      FreeCharMatrix(cube[i], rows);

   delete [] cube;

   cube = NULL;
   }

void FreeCharMatrix(char ** & matrix, int rows)
   {
   if (matrix == NULL)
      return;

   for (int i = 0; i < rows; i++)
      delete [] matrix[i];

   delete [] matrix;

   matrix = NULL;
   }

void FreeFloatMatrix(float ** & matrix, int rows)
   {
   if (matrix == NULL)
      return;

   for (int i = 0; i < rows; i++)
      delete [] matrix[i];

   delete [] matrix;

   matrix = NULL;
   }

void FreeIntMatrix(int ** & matrix, int rows)
   {
   if (matrix == NULL)
      return;

   for (int i = 0; i < rows; i++)
      delete [] matrix[i];

   delete [] matrix;

   matrix = NULL;
   }

short ** AllocateShortMatrix(int rows, int cols)
   {
   short ** matrix = new short * [rows];

   // Stop early if we are out of memory
   if (matrix == NULL)
      return NULL;

   for (int i = 0; i < rows; i++)
      {
      matrix[i] = new short [cols];

      // Safely unravel allocation if we run out of memory
      if (matrix[i] == NULL)
         {
         while (i--)
            delete [] matrix[i];

         delete [] matrix;

         return NULL;
         }
      }

   return matrix;
   }

void FreeShortMatrix(short ** & matrix, int rows)
   {
   if (matrix == NULL)
      return;

   for (int i = 0; i < rows; i++)
      delete [] matrix[i];

   delete [] matrix;

   matrix = NULL;
   }

double ** AllocateDoubleMatrix(int rows, int cols)
   {
   double ** matrix = new double * [rows];

   // Stop early if we are out of memory
   if (matrix == NULL)
      return NULL;

   for (int i = 0; i < rows; i++)
      {
      matrix[i] = new double [cols];

      // Safely unravel allocation if we run out of memory
      if (matrix[i] == NULL)
         {
         while (i--)
            delete [] matrix[i];

         delete [] matrix;

         return NULL;
         }
      }

   return matrix;
   }

void FreeDoubleMatrix(double ** & matrix, int rows)
   {
   for (int i = 0; i < rows; i++)
      delete [] matrix[i];

   delete [] matrix;

   matrix = NULL;
   }


 
