////////////////////////////////////////////////////////////////////// 
// libsrc/QuickIndex.h 
// (c) 2000-2008 Goncalo Abecasis
// 
// This file is distributed as part of the MaCH source code package   
// and may not be redistributed in any form, without prior written    
// permission from the author. Permission is granted for you to       
// modify this file for your own personal use, but modified versions  
// must retain this copyright notice and must not be distributed.     
// 
// Permission is granted for you to use this file to compile MaCH.    
// 
// All computer programs have bugs. Use this file at your own risk.   
// 
// Saturday April 12, 2008
// 
 
#ifndef __QUICKINDEX_H__
#define __QUICKINDEX_H__

#include "MathVector.h"
#include "StringArray.h"
#include "IntArray.h"
#include "StringMap.h"

class QuickIndex : public IntArray
   {
   public:
      QuickIndex();
      QuickIndex(const IntArray & source_data)
         { Index(source_data); }
      QuickIndex(const StringArray & source_data)
         { Index(source_data); }
      QuickIndex(const Vector & source_data)
         { Index(source_data); }

      void Index(const IntArray & source_data);
      void Index(const StringArray & source_data);
      void Index(const Vector & source_data);
      void IndexCounts(const StringIntMap & source_data);

   private:
      const void * source;
      int    datatype;

      bool IsBefore(int i, int j);
      void Sort();
   };

#endif

 
