#include <map>
#include <limits.h>
#include <vector>
#include <exception>
#include <iostream>
#include <math.h>
#include <stdio.h>
#include "Error.h"
#include <stdlib.h>
#include <stdarg.h>


#include "MemoryAllocators.h"
#include "Parameters.h"
#include "InputFile.h"
#include "MathMatrix.h"
#include "MathVector.h"
#include "StringArray.h"
#include "StringMap.h"

using namespace std;

class Cor
 {
public:
	String chr;
	String pos;
	Cor(){};
	~Cor(){} ;

 };


int minimac2dose(const char * sInputDose, const char * sInputInfo, const char * sOutVcf, StringMap * rsmapping)
{

	   IFILE fVcf,fDose,fInfo,fMapping;

	   Matrix dosages;
	   dosages.Zero();


	   fVcf = ifopen(sOutVcf,"wb");
	   fDose = ifopen(sInputDose,"r");
	   fInfo = ifopen(sInputInfo,"r");

	   if (fDose == NULL || fInfo == NULL){
	          error("Error opening input files.");
	   }
	   if (fVcf == NULL ){
			   error("Error opening output files.");
	   }

	   int nMarkers = 0;

	   try {

		    String line;
		    StringArray array,ids,temp;
		    int lineNo = 0;


		    while (!ifeof(fDose)){

		        line.ReadLine(fDose);
		        lineNo ++ ;
		        if (line.Length() == 0) continue;


		        array.Clear();
		        array.AddTokens(line);

		        ids.Add(array[0]);

		        if (dosages.cols != 0 && dosages.cols != array.Length() && line.Length() > 0) {
		            fprintf(stderr, "Wrong column size at line %d!\n", lineNo);
		            return -1;
		        } else {
		            dosages.GrowTo(dosages.rows, array.Length());
		        }
		        if (dosages.rows < lineNo) {
		            dosages.GrowTo(dosages.rows+1, dosages.cols);
		        }
		        for (int i = 2; i < array.Length(); i++) {
		            dosages[lineNo-1][i-2] = atof(array[i]);
		        }


		        printf("%5d\b\b\b\b\b",lineNo); fflush(stdout);
		    }


		    //output

		    printf("\n Output VCF...");
		    fflush(stdout);

		    //add header
		    ifprintf(fVcf,"##fileformat=VCFv4.1\n");
		    ifprintf(fVcf,"#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT");

	            printf("Header..."); fflush(stdout);

		    // add individuals
		    for (int i = 0; i < ids.Length(); i++) {
		    	ifprintf(fVcf,"\t");
		    	ifprintf(fVcf,"%s",ids[i].c_str());
		    }

		    ifprintf(fVcf,"\n");

	            //printf("IDs...%d * %d",ids.Length(),dosages.cols); fflush(stdout);

	            int col = 0;
		    // skip first row
		    line.ReadLine(fInfo);
	            //lineNo = 0;

		    printf("Data..."); fflush(stdout);

		    while (!ifeof(fInfo)){

				  line.ReadLine(fInfo);

				  if (line.Length() == 0) continue;

				  array.Clear();
				  array.AddTokens(line);
				  temp.Clear();
				  temp.AddTokens(array[0],":");

				  if(temp.Length()==1)
	              {

					  Cor* data = (Cor*)rsmapping->Object(temp[0]);

					  if(data!=NULL){
						 temp.Clear();
						 temp.Add(data->chr);
						 temp.Add(data->pos);

					  }else
					  {
	                    col++;
	                    continue;
					  }
	              }

		          ifprintf(fVcf,"%s",temp[0].c_str());
		          ifprintf(fVcf,"\t");
		          ifprintf(fVcf,"%s",temp[1].c_str());
		          ifprintf(fVcf,"\t");
		          ifprintf(fVcf,"%s",array[0].c_str());
		          ifprintf(fVcf,"\t");
		          ifprintf(fVcf,"%s",array[1].c_str());
		          ifprintf(fVcf,"\t");
		          ifprintf(fVcf,"%s",array[2].c_str());
		          ifprintf(fVcf,"\t");
		          // ifprintf(fVcf,"%1.0f",floor(atof(array[6])*100));
		          ifprintf(fVcf,"0");
	                  ifprintf(fVcf,"\t");
		          ifprintf(fVcf,"PASS");
		          ifprintf(fVcf,"\t");
		          ifprintf(fVcf,".");
	                  ifprintf(fVcf,"\t");
		          ifprintf(fVcf,"GT:EC");

		          for (int i = 0; i < lineNo; i++) {

		             ifprintf(fVcf,"\t");

		             if ( dosages[i][col] < 0.5 ){
		               ifprintf(fVcf,"1/1");
		             }else if(dosages[i][col] > 1.5){
		               ifprintf(fVcf,"0/0");
		             }else{
		               ifprintf(fVcf,"0/1");
		             }

		            ifprintf(fVcf,":%1.4f",dosages[i][col]);

		          }

		          ifprintf(fVcf,"\n");

		          col++;

		    }

	     ifclose(fVcf);
	     ifclose(fDose);
	     ifclose(fInfo);
	   }

	   catch (int e) {
		   cout << "Exception # " << e << endl;
	   }


}


int impute2dose(const char * sInputImpute, const char * sInputSample, const char * sOutVcf, StringMap * rsmapping, const char * sChr)
{

	   IFILE fVcf,fImpute,fSample,fMapping;

       String line;
       StringArray array,ids,temp;
	   int lineNo = 0;


	   fVcf = ifopen(sOutVcf,"wb");
	   fImpute = ifopen(sInputImpute,"r");
	   fSample = ifopen(sInputSample,"r");

	   if (fImpute == NULL || fSample == NULL){
	          error("Error opening input files.");
	   }
	   if (fVcf == NULL ){
			   error("Error opening output files.");
	   }


	    //output
	    printf("\n Output VCF...\n\n"); fflush(stdout);

     try {

	    //add header
	    ifprintf(fVcf,"##fileformat=VCFv4.1\n");
	    ifprintf(fVcf,"#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT");

	    //Skip first 2 lines
        line.ReadLine(fSample);
        line.ReadLine(fSample);

	    while (!ifeof(fSample)){

	        line.ReadLine(fSample);
	        if (line.Length() == 0) continue;

	        array.Clear();
	        array.AddTokens(line);

	    	ifprintf(fVcf,"\t");
	    	ifprintf(fVcf,"%s",array[0].c_str());
	    }

	    ifprintf(fVcf,"\n");

		lineNo = 0;

		    while (!ifeof(fImpute)){

		        line.ReadLine(fImpute);
		        lineNo ++ ;
		        if (line.Length() == 0) continue;


		        array.Clear();
		        array.AddTokens(line);

		        if (line.Length() > 0) {

						  //--- rs7922705 66327503 T C 0 0.998 0 0.998 0.002
						  // 20      60479   rs149529999     C       T       0
				          ifprintf(fVcf,"%s",sChr);
				          ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"%s",array[2].c_str());
				          ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"%s",array[1].c_str());
				          ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"%s",array[3].c_str());
				          ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"%s",array[4].c_str());
				          ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"0");
			              ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"PASS");
				          ifprintf(fVcf,"\t");
				          ifprintf(fVcf,".");
			              ifprintf(fVcf,"\t");
				          ifprintf(fVcf,"GT:EC:PL3");

				          int i=5;
				          double dose = 0;

						  while(i < array.Length()) {

                              dose = atof(array[i])*2.0 + atof(array[i+1]);

						      ifprintf(fVcf,"\t");

							  if ( dose > 1.5 ){
								   ifprintf(fVcf,"0/0");
							  }else if(dose < 0.5){
								   ifprintf(fVcf,"1/1");
							  }else{
								   ifprintf(fVcf,"0/1");
							  }

						      ifprintf(fVcf,":%1.4f",dose);

						      ifprintf(fVcf,":%1.3f,%1.3f,%1.3f",atof(array[i]),atof(array[i+1]),atof(array[i+2]));


							  i=i+3;
						 }
		          }
				  ifprintf(fVcf,"\n");
		          printf("%5d\b\b\b\b\b",lineNo); fflush(stdout);
		    }

	     ifclose(fVcf);
	     ifclose(fImpute);
	     ifclose(fSample);
	   }

	   catch (int e) {
		   cout << "Exception # " << e << endl;
	   }


}


int main(int argc, char ** argv)
{
   printf("dose2vcf 0.6\n"
          "(c) 2013 Christian Fuchsberger\n\n");


   String sInputDose("");
   String sInputImpute("");
   String sInputInfo("");
   String sInputSample("");
   String sInputRS("");
   String sChr("");


   String sType("minimac");
   bool minimac = true;
   String sInputMapping("");
   

   String sOut("dose2vcf");

   ParameterList pl;

   BEGIN_LONG_PARAMETERS(longParameters)
     LONG_PARAMETER_GROUP("Minimac input options")
     	 LONG_STRINGPARAMETER("dose",&sInputDose)
     	 LONG_STRINGPARAMETER("info",&sInputInfo)
     LONG_PARAMETER_GROUP("Impute2 input options")
     	 LONG_STRINGPARAMETER("impute_dose",&sInputImpute)
     	 LONG_STRINGPARAMETER("impute_sample",&sInputSample)
         LONG_STRINGPARAMETER("chr", &sChr)
     LONG_PARAMETER_GROUP("RS mapping table")
         LONG_STRINGPARAMETER("rs",&sInputRS)
     LONG_PARAMETER_GROUP("Output Options")
     	 LONG_STRINGPARAMETER("prefix",&sOut)
   END_LONG_PARAMETERS();

   pl.Add(new LongParameters("Available Options", longParameters));
   pl.Read(argc, argv);
   pl.Status();

   // Checks
   if ( sOut.IsEmpty() ) {
     fprintf(stderr,"ERROR: output prefix is empty\n");
     abort();
   }

   if(!sInputDose.IsEmpty() && !sInputInfo.IsEmpty())
     printf("Minimac mode\n");

   else{
	   if( !sInputImpute.IsEmpty() && !sInputSample.IsEmpty() && !sChr.IsEmpty()){
		   printf("Impute2 mode\n");
		   minimac = false;
	   }
	   else{
		   fprintf(stderr,"ERROR: Please provide input files and chromosome\n");
	       abort();
	   }
   }

   String sOutVcf = sOut + ".vcf";

   IFILE fRS;
   StringMap	* rsmapping = new StringMap;

	if (sInputRS.Length())
	{

		printf("Load RS mapping table...\n");

		fRS = ifopen(sInputRS,"r");

	    if (fRS== NULL)
	      error("Error opening RS mapping file.");

	    StringArray array;
	    String line;

	    int lineNo = 0;
	    while (!ifeof(fRS)){

	    	          line.ReadLine(fRS);

					  if (line.Length() == 0) continue;

					  array.Clear();
					  array.AddTokens(line);
					  Cor* temp = new Cor;

					  temp->chr = array[0];
					  temp->pos = array[1];
					  rsmapping->Add(array[2],temp);

					  if(lineNo%1000){
					     printf("%8d\b\b\b\b\b\b\b\b",lineNo); fflush(stdout);
					  }
			          lineNo++;
	    }
	    ifclose(fRS);
	}

   printf("Load Dosages...\n");

   if(minimac)
    return minimac2dose(sInputDose, sInputInfo, sOutVcf, rsmapping);
   else
	return impute2dose(sInputImpute, sInputSample, sOutVcf, rsmapping, sChr);

  printf("Done\n");
}


