#ifndef _GREEDY_TUPLE_H
#define _GREEDY_TUPLE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include "Generic.h"
#include "CigarRoller.h"

// #define DEBUG_GREEDY_ALIGNER

/*
 *

 TODO:
 1. how to efficiently find insertion?

*/

class Weight {
public:
    Weight() {
        gapOpen = gapExtend = -1; // here we do not use affine gap penalty for simlicity.
        mismatch = -1;
        match= 2;
    };
    int gapOpen;
    int gapExtend;
    int mismatch;
    int match;
};

//
// tuple number is 3, arbitrary number from my guess!
// another reason
//
template <typename QueryType, typename ReferenceType, typename ReferenceIndex>
class GreedyTupleAligner {
public:
    GreedyTupleAligner(Weight& wt): weight(wt) {/* */}

    int MatchTuple(
            QueryType query,
            ReferenceType reference,
            ReferenceIndex  searchStartIndex,
            int searchSize,
            int& matchedLength,
            int& mismatch) {
        // now use naive search,
        // TODO: will incorportate KMP serach later
        // TODO: adjust tolerance of mismatches
        const int MAX_MISMATCH=2;
        int bestPos, bestMismatch, bestMatchedLength, bestScore=-1;

#if defined(DEBUG_GREEDY_ALIGNER)
        cout << "searchStartIndex == " << searchStartIndex << ", searchSize == " << searchSize << std::endl;
#endif
        for (int i = 0; i <= searchSize - tupleSize; i++) {
            int j = 0;
            mismatch = 0;
            while(query[j]!='\0' /* && (i+j >= searchSize) */ ) {
                if (query[j] != reference[searchStartIndex + i+j]) {
                    mismatch++;
                    if (mismatch >= MAX_MISMATCH) 
                        break;
                }
                j++;
            }
            if (j>0 && (query[j]=='\0' /* || (i+j >= searchSize) */ )) j--;

            while(query[j] != reference[searchStartIndex + i+j] && ((j+1) > mismatch) && mismatch>0) { // reverse mismatch at the end.
                j--;
                mismatch--;
            }

            int score = j - mismatch;

            if (score > bestScore) {
                bestPos = i;
                bestScore = score;
                bestMismatch = mismatch;
                bestMatchedLength = j+1;
            }
        }
        
        if (bestScore > 0) {
            mismatch = bestMismatch;
            matchedLength = bestMatchedLength;
            return bestPos;
        }
        return -1;
    }

    void Align(
            QueryType query,
            int queryLength,
            ReferenceType reference,
            ReferenceIndex  searchStartIndex,
            int searchSize,
            CigarRoller& cigarRoller,
            ReferenceIndex &matchPosition) {
        // Algorithm:
        // finished align? (should we try different align position?)
        // if not, try next tuple
        //    is the tuple aligned?
        //    yes, extend to previous, mark unmatched part mismatch or gap
        //         extend to next matched part
        int r1 = 0; // a start index: reference starting from r1 (inclusive) will be used 
        int queryMatchCount = 0; // query matched # of bases
        int q1 = 0; // to align
        int pos = -1;
        int lastR1 = -1; // index: record last

        cigarRoller.clear();

        while (queryMatchCount < queryLength) {
            if (r1 == searchSize - 1) { // touched ref right boundary
                cigarRoller.Add(CigarRoller::softClip, queryLength-queryMatchCount);
                break;
            }
            if (queryLength - q1 < tupleSize) {
                // XXX this needs to do something more sane
                // printf("some bases left!\n");
                // a simple fix: treat all left-over bases as mismatches/matches
                cigarRoller.Add(CigarRoller::mismatch, queryLength - queryMatchCount);
                break;
            }
            int mismatch = 0;
            int matchedLen = 0;
            if ((pos = MatchTuple(query+q1, reference, searchStartIndex + r1, searchSize - r1, matchedLen, mismatch)) // found match position for tuple
                >= 0) {

                if (lastR1<0)
                    matchPosition = pos;

                //
                // deal with left
                //
                r1 += pos;
                if (lastR1>=0 && pos > 0 ) {
                    cigarRoller.Add(CigarRoller::del, pos);
                }

                if (lastR1<0) {
                    lastR1 = pos;
                } 
                
                r1 += matchedLen;
                q1 += matchedLen;

                //
                // deal with right
                //
                cigarRoller.Add(CigarRoller::match, matchedLen);
                queryMatchCount = q1;
                lastR1 = r1;

                continue;
            } // end if

            //
            // try insertion
            // maximum insert ? say 2
            //
            for (int i = 1; i < queryLength - q1 - tupleSize; i++ ) {
                int mismatch = 0;
                int matchedLen = 0;
                if ((pos = MatchTuple(query+q1 + i , reference, searchStartIndex + r1, searchSize - r1, matchedLen, mismatch)) // found match position for tuple
                    >= 0) {
                }
                queryMatchCount += i;
                q1 += i;
                cigarRoller.Add(CigarRoller::insert, i);

                lastR1 = r1 + pos;
                r1 += pos + tupleSize;
                q1 += tupleSize;
                // deal with right
                while (query[q1]==reference[searchStartIndex + r1] && q1 < queryLength) {
                    r1++;
                    q1++;
                }
                if (q1 < queryLength) {
                    cigarRoller.Add(CigarRoller::match, q1 - queryMatchCount);
                    queryMatchCount = q1;
                } else {
                    cigarRoller.Add(CigarRoller::match, queryLength - queryMatchCount);
                    queryMatchCount = queryLength ;
                    break ;
                }
            }

            r1++;
            q1++;

            // try next
        } // end while (queryMatchCount < queryLength)
    }
private:
    static const int tupleSize = 3;
    Weight weight;
};


#endif
