//////////////////////////////////////////////////////////////////////
// BiBalance.cpp
// Author: Wei-Min Chen
// March 23, 2007

#include "BiBalance.h"
#include "Kinship.h"
#include "QuickIndex.h"
#include "MultiBalance.h"
#include <math.h>

void POLY_Bivariate_Balance::RefreshOD(int f)
{
   M.Product(Phi, Phi);
   M.Multiply(variances[3]*variances[4]-variances[5]*variances[5]);
   M.AddMultiple(variances[0]*variances[4]+variances[1]*variances[3]-2*variances[2]*variances[5], Phi);
   double t = variances[0]*variances[1]-variances[2]*variances[2];
   for(int i = 0; i < count; i++) M[i][i] += t;
   bi_chol.Decompose(M);
   bi_chol.Invert(); // most computationally intensive part
   M.Product(Phi, bi_chol.inv);
   O[0] = O[1] = O[2] = M;
   O[0].Multiply(variances[4]);
   O[0].AddMultiple(variances[1], bi_chol.inv);
   O[1].Multiply(variances[3]);
   O[1].AddMultiple(variances[0], bi_chol.inv);
   O[2].Multiply(-variances[5]);
   O[2].AddMultiple(-variances[2], bi_chol.inv);
   
// More efficient than for(int i = 0; i < 3; i++) OP[i].Product(O[i], Phi);
   bi_chol.inv.Transpose(M);
   M.Product(Phi, bi_chol.inv);
   OP[0] = OP[1] = OP[2] = M;
   OP[0].Multiply(variances[4]);
   OP[0].AddMultiple(variances[1], bi_chol.inv);
   OP[1].Multiply(variances[3]);
   OP[1].AddMultiple(variances[0], bi_chol.inv);
   OP[2].Multiply(-variances[5]);
   OP[2].AddMultiple(-variances[2], bi_chol.inv);

   for(int i = 0; i < 6; i++) OD[i].Zero();
   for(int i = 0; i < count; i++)
      for(int j = 0; j < count; j++)
         for(int k = 0; k < 2; k++)
            for(int u = 0; u < 2; u++){
               OD[u][count*k+i][count*u+j] = O[Idx[k][u]][i][j];
               OD[parCount/2+u][count*k+i][count*u+j] = OP[Idx[k][u]][i][j];
               for(int v = u+1; v < 2; v++){
                  OD[Idx[u][v]][count*k+i][count*u+j] = O[Idx[k][v]][i][j];
                  OD[Idx[u][v]][count*k+i][count*v+j] = O[Idx[k][u]][i][j];
                  OD[parCount/2+Idx[u][v]][count*k+i][count*u+j] = OP[Idx[k][v]][i][j];
                  OD[parCount/2+Idx[u][v]][count*k+i][count*v+j] = OP[Idx[k][u]][i][j];
               }
            }
}

void POLY_Bivariate_Balance::solve()
{
   InitCoef();

   Vector TempVector;
   Matrix TempM;
   double sum;
   Matrix OS;
   Cholesky chol;

   Matrix OC;     // OC = O * C
   Vector OR;     // OR = O * R
   Vector buf;
   SEvariances.Dimension(parCount);
   SEcoef.Dimension(coefCount);
   Matrix DVD(parCount, parCount);
   Matrix BOB(coefCount, coefCount);
   Vector DVS(parCount);
   Vector BOY(coefCount);
   Matrix DVS_FAM(parCount, ped.familyCount);
   Matrix BOY_FAM(coefCount, ped.familyCount);
   if(OD) delete[]OD;
   OD = new Matrix[parCount];
   for(int loop = 0; loop < LoopCount; loop++){

      loglik = 0;
      DVD.Zero();
      BOB.Zero();
      DVS_FAM.Zero();
      BOY_FAM.Zero();
      for (int f = 0; f < ped.familyCount; f++){
         size = pheno[f].Length();
         if(size==0) continue;
         GetPhi(f);        //   Refresh(f);
         OR.Dimension(size);
         OC.Dimension(coefCount, size);
         TempVector.Dimension(size);
         for(int i = 0; i < parCount; i++)
            OD[i].Dimension(size, size);
         OS.Dimension(size, size);

         buf = traits[f];
         for(int i = 0; i < size; i++)
            for(int j = 0; j < coefCount; j++)
                buf[i] -= coef[j] * covariates[f][j][i];

         RefreshOD(f);

         M.Dimension(size, size);
         for(int i = 0; i < count; i++)
            for(int j = 0; j < count; j++){
               M[i][j] = O[0][i][j];
               M[i][count+j] = M[count+i][j] = O[2][i][j];
               M[count+i][count+j] = O[1][i][j]; 
            }
         TempM.Product(covariates[f], M);
         for(int i = 0; i < coefCount; i++)
            for(int k = 0; k < size; k++){
               for(int j = 0; j < coefCount; j++)
                  BOB[i][j] += TempM[i][k] * covariates[f][j][k];
               BOY_FAM[i][f] += TempM[i][k] * buf[k];
            }
         TempVector.Dimension(size);
         TempVector.Zero();
         for(int i = 0; i < size; i++)
            for(int j = 0; j < size; j++)
               TempVector.data[i] += M.data[i]->data[j] * buf.data[j];
         for(int u = 0; u < size; u++)
            for(int v = 0; v < size; v++)
               OS.data[u]->data[v] = TempVector.data[u] * buf.data[v];
         for(int u = 0; u < size; u++)
            OS.data[u]->data[u] --;

         // DVDij = Tr(ODiODj)/2
         for(int u = 0; u < size; u++)
            for(int v = 0; v < size; v++)
               for(int i = 0; i < parCount; i++){
                  for(int j = i; j < parCount; j++)
                     DVD.data[i]->data[j] += OD[i].data[u]->data[v] * OD[j].data[v]->data[u];
                  DVS_FAM.data[i]->data[f] += OD[i].data[u]->data[v] * OS.data[v]->data[u] * 0.5 ;
               }
      }  // end of f

      for(int i = 0; i < coefCount; i++) BOY[i] = BOY_FAM[i].Sum();
      for(int i = 0; i < parCount; i++) DVS[i] = DVS_FAM[i].Sum();
      chol.Decompose(BOB);

      chol.Invert();
      CovCoef = chol.inv;
      delta2.Dimension(coefCount);
      delta2.Zero();
      for(int i = 0; i < coefCount; i++)
         for(int j = 0; j < coefCount; j++)
            delta2[i] += CovCoef[i][j] * BOY[j];
      coef.Add(delta2);

      for(int i = 0; i < parCount; i++)
         for(int j = i; j < parCount; j++)
            DVD[j][i] = DVD[i][j] = DVD[i][j] * 0.5;
      chol.Decompose(DVD);
      chol.Invert();
      covariance = chol.inv;
      delta.Dimension(parCount);
      delta.Zero();
      for(int i = 0; i < parCount; i++)
         for(int j = 0; j < parCount; j++)
            delta[i] += covariance[i][j] * DVS[j];
      if(deltaScale != 1.0)
         for(int i = 0; i < parCount; i++)
            delta[i] *= deltaScale;
      variances.Add(delta);
      if(constraint()) AtBorder = 1;
      if(delta.SumSquares() < Epsilon) break;
   }  // end of loop

   Matrix BOB2(coefCount, coefCount);
   BOB2.Zero();
   for(int i = 0; i < coefCount; i++)
      for(int j = 0; j < coefCount; j++)
         for(int f = 0; f < ped.familyCount; f++)
              BOB2[i][j] += BOY_FAM[i][f] * BOY_FAM[j][f];
   CovCoef_R.Dimension(coefCount, coefCount);
   CovCoef_R.Zero();
   for(int i = 0; i < coefCount; i++)
      for(int j = i; j < coefCount; j++){
         for(int u = 0; u < coefCount; u++)
            for(int v = 0; v < coefCount; v++)
               CovCoef_R[i][j] += CovCoef[i][u] * BOB2[u][v] * CovCoef[v][j];
         CovCoef_R[j][i] = CovCoef_R[i][j];
      }

   SEcoef_R.Dimension(coefCount);
   for(int i = 0; i < coefCount; i++){
      if(CovCoef[i][i]>0) SEcoef[i] = sqrt(CovCoef[i][i]);
      else continue;
      if(CovCoef_R[i][i]>0) SEcoef_R[i] = sqrt(CovCoef_R[i][i]);
      else continue;
   }

   Matrix DVD2(parCount, parCount);
   DVD2.Zero();
   for(int i = 0; i < parCount; i++)
      for(int j = 0; j < parCount; j++)
         for(int f = 0; f < ped.familyCount; f++)
              DVD2[i][j] += DVS_FAM[i][f] * DVS_FAM[j][f];
   covariance_R.Dimension(parCount, parCount);
   covariance_R.Zero();
   for(int i = 0; i < parCount; i++)
      for(int j = i; j < parCount; j++){
         for(int u = 0; u < parCount; u++)
            for(int v = 0; v < parCount; v++)
               covariance_R[i][j] += covariance[i][u] * DVD2[u][v] * covariance[v][j];
         covariance_R[j][i] = covariance_R[i][j];
      }
   SEvariances_R.Dimension(parCount);
   for(int i = 0; i < parCount; i++){
      if(covariance[i][i]>0) SEvariances[i] = sqrt(covariance[i][i]);
      else continue;
      if(covariance_R[i][i]>0) SEvariances_R[i] = sqrt(covariance_R[i][i]);
      else continue;
   }
   /*
   // MLE stuff
   loglik = 0;
   for (int f = 0; f < ped.familyCount; f++){
      size = pheno[f].Length();
      if(size==0) continue;
      GetPhi(f);
      RefreshO(f);
      buf = traits[f];
      for(int i = 0; i < size; i++)
         for(int j = 0; j < coefCount; j++)
            buf[i] -= coef[j] * covariates[f][j][i];
      CholeskyOmega.Decompose(Omega);
      CholeskyOmega.BackSubst0(buf);
      for(int i = 0; i < size; i++) {
         loglik -= CholeskyOmega.x[i] * CholeskyOmega.x[i] / 2;
         loglik -= log(fabs(CholeskyOmega.L[i][i]));
      }
   } */
   summary();
}




