#ifndef __FAMILYLIKELIHOOD_H__
#define __FAMILYLIKELIHOOD_H__

#include "Pedigree.h"
#include "MathMatrix.h"
#include "Kinship.h"
           
class ES_TRAVERSE{
   public:
      IntArray Index;
      IntArray From;
      IntArray To;
      IntArray Type;

      IntArray *States;
      Vector *Items;

      ES_TRAVERSE();
      ~ES_TRAVERSE();
      void GetOrder(Family * family);
      void GetOrder(Family * family, int traverse);
      void PrintOrder(Family * family);
      ES_TRAVERSE & operator=(ES_TRAVERSE & es);
};

class FamilyLikelihood{
   public:
      // Elston-Stewart algorithm
      ES_TRAVERSE es;
      ES_TRAVERSE * esPerson;
      Kinship kin;

      // Family whose likelihood we are calculating
      Family * family;

      Vector stateProb;
      Vector stateTransmission;
      int stateCount;
      double SavedLikelihood;

      Vector AlleleCount;
      Matrix AlleleCovariance;
      Vector AlleleVariance;
      Vector AlleleDistribution[3];
      Vector frequencies;
      IntArray order;
      int orderCount;
      int MaxDimension;

      int markerOrder;
      Vector distances;
      Vector recombinations;
      int positionSNP;
      IntArray *phase;
      IntArray genotypeVector;
      IntArray *genotypeArray;
      // Constructor and destructor
      FamilyLikelihood();
      virtual ~FamilyLikelihood();

      // Basic components of likelihood calculation
      virtual double ProbabilityOfPhenotype(Person & person, int state){return 0;};
      virtual double ProbabilityOfState(int state) = 0;
      virtual double ProbabilityOfTransmission(int child_state, int maternal_state, int paternal_state) = 0;

      virtual int GenotypeMeasure(int state) = 0;

      virtual double LikelihoodOfGenotype();

      // Overall likelihood for this family
      virtual double  Likelihood();

      // score evaluated at null
      virtual double score();
      virtual void GetCovariance();
      virtual void GetVariance();

      // Initialization functions
      virtual void SelectLocus() = 0;
      virtual void SelectFamily(Family * family_ptr);
      virtual void UpdateFrequency() = 0;
      virtual void ListStates(Person & person, IntArray & states) = 0;

      virtual void ResetES();
      virtual void init(FamilyLikelihood *){}
      virtual void CopyPhase(FamilyLikelihood *){}

   protected:
      int stateHapCount;
      double nuclearFamilyLikelihood();

};

class FamilyLikelihoodNull: public FamilyLikelihood{
   protected:
      IntArray * IntToVector;
   public:
      int AllSNP;
      int stateLength;
      int stateHapLength;
      IntArray AllelesPerLocus;
      IntArray Locus;
      IntArray IsAlleleOne;

      // Additional settings
      int trait;
      IntArray pheno;

      // Constructor
      FamilyLikelihoodNull();
      virtual ~FamilyLikelihoodNull(){}

      // Inherited functions
      virtual double ProbabilityOfState(int state)
      {return stateProb[state];}
      virtual double ProbabilityOfTransmission(int child_state, int maternal_state, int paternal_state)
      {return stateTransmission[paternal_state * 9 + maternal_state * 3 + child_state];}
      virtual inline void ListStates(Person & person, IntArray & states)
      {states = IntToVector[genotypeVector[person.serial]];
/*      printf("%d", genotypeVector[person.serial]); states.Print();*/}
      virtual void SelectLocus();
      virtual inline int GenotypeMeasure(int state) {return state;}
      virtual inline void UpdateFrequency()
{  stateProb[0] = frequencies[markerOrder] * frequencies[markerOrder];
   stateProb[1] = frequencies[markerOrder] * (1.0 - frequencies[markerOrder]) * 2.0;
   stateProb[2] = (1.0 - frequencies[markerOrder]) * (1.0 - frequencies[markerOrder]);}
};

class FamilyLikelihoodSNP: public FamilyLikelihoodNull{
   public:
      FamilyLikelihoodSNP(){}
      ~FamilyLikelihoodSNP(){}
};

class FamilyLikelihoodHAP: public FamilyLikelihoodNull{
   protected:
      IntArray * IntToArray;
   public:
      FamilyLikelihoodHAP();
      virtual ~FamilyLikelihoodHAP();
      virtual void SelectLocus();
      virtual inline int GenotypeMeasure(int state);
      virtual double ProbabilityOfState(int state)
      {return stateProb[haploid[0][state]] * stateProb[haploid[1][state]];}
      virtual double ProbabilityOfTransmission(int child_state, int maternal_state, int paternal_state)
{return RecomProb[IsAlleleOne[maternal_state ^ binaryDouble[haploid[0][child_state]]]]
 * RecomProb[IsAlleleOne[paternal_state ^ binaryDouble[haploid[1][child_state]]]];}
      virtual void ListStates(Person & person, IntArray & states);
      virtual void UpdateFrequency();
      virtual double LikelihoodOfGenotype();

   protected:
      Vector TransmissionHaploidProbability;
      IntArray haploid[2];
      Vector RecomProb;

      IntArray OneState[13];
      IntArray base;
      IntArray BitsPerLocus;
      IntArray LocusBit;

      IntArray BinaryBase;
      IntArray binaryDouble;
      IntArray *binary;
      IntArray AllOne;
      void ConvertNumber(long int number, IntArray & out, int bit);
      double nuclearFamilyLikelihood();
};


class FamilyLikelihoodEff: public FamilyLikelihoodHAP{
   public:
      int FixedPerson;
      FamilyLikelihoodEff();
      virtual ~FamilyLikelihoodEff(){}
      virtual inline int GenotypeMeasure(int state);
      virtual double ProbabilityOfState(int state)
{return stateProb[haploid[0][convertState[state]]] * stateProb[haploid[1][convertState[state]]];}
      virtual inline double ProbabilityOfTransmission(int child_state, int maternal_state, int paternal_state)
{ return RecomProb[IsAlleleOne[convertState[maternal_state] ^ binaryDouble[haploid[0][convertState[child_state]]]]]
   * RecomProb[IsAlleleOne[convertState[paternal_state] ^ binaryDouble[haploid[1][convertState[child_state]]]]];}
      virtual void ListStates(Person & person, IntArray & states);
      IntArray convertState;
      virtual void init(FamilyLikelihood *);
      virtual void CopyPhase(FamilyLikelihood *);
};

class FamilyLikelihoodIBD: public FamilyLikelihoodEff{
   public:
      FamilyLikelihoodIBD();
      virtual ~FamilyLikelihoodIBD(){}
      virtual void ListStates(Person & person, IntArray & states);
      void init(FamilyLikelihood *);
      virtual double score();
};

class FamilyLikelihoodIBD2: public FamilyLikelihoodEff{
   public:
      FamilyLikelihoodIBD2();
      virtual ~FamilyLikelihoodIBD2(){}
      virtual void ListStates(Person & person, IntArray & states);
      void init(FamilyLikelihood *);
      void CopyPhase(FamilyLikelihood *);
      virtual double score();
};

class BiallelicLocus : public FamilyLikelihoodHAP{
   private:
      double genotype_mean[3];
   public:
      // Parameters for simple model with one biallelic locus

      double variance;
      double mu, a, d;

      // Constructor
      BiallelicLocus();
      ~BiallelicLocus(){}

      // Inherited functions
      virtual double ProbabilityOfPhenotype(Person & person, int state);
      virtual void UpdateSegregation();
};

class FamilyLikelihoodPerson: public FamilyLikelihoodHAP{
   public:
      int lastPerson;
      FamilyLikelihoodPerson();
      virtual ~FamilyLikelihoodPerson();
      virtual void SelectFamily(Family * family_ptr);
      void ResetESP(int person);
      virtual double LikelihoodOfGenotype();
   protected:
      double nuclearFamilyLikelihood();
};

/*
class SimplePolygenicModel : public FamilyLikelihood
   {
   public:
      // Parameters for simple model with one biallelic locus
      double frequency;
      double genotype_mean[3];
      double residual_variance;
      double polygenic_variance;

      // Additional settings
      int trait;              // Quantitative Trait being modelled
      int grid_points;        // Grid points for modelling polygenic effect

      // Constructor
      SimplePolygenicModel();

      // Inherited functions
      virtual double ProbabilityOfPhenotype(Person & person, int state);
      virtual double ProbabilityOfState(int state);
      virtual double ProbabilityOfTransmission(int child_state, int maternal_state, int paternal_state);
      virtual void ListStates(Person & person, IntArray & states);
   };
*/
/*      virtual void SelectNuclearFamily(Family * family_ptr);
      virtual double NuclearLikelihood();
      virtual double NuclearLikelihoodOfGenotype();
      virtual double NuclearScore();
//      Person * mother, * father;

      // Lists of possible states for each individual
//      IntArray   maternal_states;
//      IntArray   paternal_states;
//      IntArray * child_states;

      */

#endif



