//////////////////////////////////////////////////////////////////////
// VCGEE.cpp
// Author: Wei-Min Chen
// Oct 10, 2004

#include "VCGEE.h"
#include "Pedigree.h"
#include "Kinship.h"
#include "MathStats.h"
#include "QuickIndex.h"
#include <math.h>

GEE::GEE(Pedigree & pedigree):ped(pedigree)
{
   pheno = NULL; traits = NULL; covariates = NULL; OD = NULL;
   LoopCount = 20; Epsilon = 1E-6;
   deltaScale = 1.0; 
   AtBorder = 0;
   borderIndex.Dimension(0);
}

GEE::~GEE()
{
   if(pheno) delete []pheno;
   if(traits) delete []traits;
   if(covariates) delete []covariates;
   if(OD) delete []OD;
}

void GEE::GetPhi(int f)
{
   Kinship kin;
   Phi.Dimension(size, size);
   kin.Setup(*ped.families[f]);

   for(int i = 0; i < size; i++){
      Phi[i][i] = 1;
      for(int j = i+1; j < size; j++)
         Phi[j][i] = Phi[i][j] = 2 * kin(ped[pheno[f][i]], ped[pheno[f][j]]);
   }
}

void GEE::Refresh(int f)
{
   GetPhi(f);
   RefreshO(f);
   RefreshD(f);
}

void GEE::RefreshOD(int f)
{
   Vector TempVector(size);
   for(int i = 0; i < parCount; i++)
      for(int u = 0; u < size; u++){      // column u
         for(int v = 0; v < size; v++)
            TempVector[v] = D[Index(v,u)][i];
            CholeskyOmega.BackSubst(TempVector); // most intensive computation
            for(int v = 0; v < size; v++)    // row v
               OD[i][v][u] = CholeskyOmega.x[v];
      }
}

int GEE::constraint(void)
{
   int r = 0;
   for(int i = 0; i < parCount; i++)
      if(variances[i] < 0){
         variances[i] = 0.0000001;
         r = 1;
      }
   return r;
}

void GEE::solve()
{
   InitCoef();
   Vector TempVector;
   double sum;
   Matrix OS;
   Cholesky chol;

   Matrix OC;     // OC = O * C
   Vector OR;     // OR = O * R
   Vector buf;
   SEvariances.Dimension(parCount);
   SEcoef.Dimension(coefCount);
   Matrix DVD(parCount, parCount);
   Matrix BOB(coefCount, coefCount);
   Vector DVS(parCount);
   Vector BOY(coefCount);
   Matrix DVS_FAM(parCount, ped.familyCount);
   Matrix BOY_FAM(coefCount, ped.familyCount);
   if(OD) delete[]OD;
   OD = new Matrix[parCount];
   for(int loop = 0; loop < LoopCount; loop++){
      loglik = 0;
      DVD.Zero();
      BOB.Zero();
      DVS_FAM.Zero();
      BOY_FAM.Zero();
      for (int f = 0; f < ped.familyCount; f++){
         size = pheno[f].Length();
         if(size==0) continue;
         Refresh(f);

         OR.Dimension(size);
         OC.Dimension(coefCount, size);
         TempVector.Dimension(size);
         for(int i = 0; i < parCount; i++)
            OD[i].Dimension(size, size);
         OS.Dimension(size, size);

         buf = traits[f];
         for(int i = 0; i < size; i++)
            for(int j = 0; j < coefCount; j++)
                buf[i] -= coef[j] * covariates[f][j][i];
         CholeskyOmega.Decompose(Omega);
         for(int i = 0; i < coefCount; i++){
            CholeskyOmega.BackSubst0(covariates[f][i]);
            OC[i] = CholeskyOmega.x;
         }
         CholeskyOmega.BackSubst0(buf);
         OR = CholeskyOmega.x;
         for(int i = 0; i < coefCount; i++)
            for(int k = 0; k < size; k++){
               for(int j = 0; j < coefCount; j++)
                  BOB.data[i]->data[j] += OC.data[i]->data[k] * OC.data[j]->data[k];
               BOY_FAM.data[i]->data[f] += OC.data[i]->data[k] * OR.data[k];
            }

         RefreshOD(f);

         CholeskyOmega.BackSubst(buf);
         for(int u = 0; u < size; u++)
            for(int v = 0; v < size; v++)
               OS.data[u]->data[v] = CholeskyOmega.x.data[u] * buf.data[v];
         for(int u = 0; u < size; u++)
            OS.data[u]->data[u] --;

         // DVDij = Tr(ODiODj)/2
         for(int u = 0; u < size; u++)
            for(int v = 0; v < size; v++)
               for(int i = 0; i < parCount; i++){
                  for(int j = i; j < parCount; j++)
                     DVD.data[i]->data[j] += OD[i].data[u]->data[v] * OD[j].data[v]->data[u];
                  DVS_FAM.data[i]->data[f] += OD[i].data[u]->data[v] * OS.data[v]->data[u] * 0.5 ;
               }
      }  // end of f


      for(int i = 0; i < coefCount; i++) BOY[i] = BOY_FAM[i].Sum();
      for(int i = 0; i < parCount; i++) DVS[i] = DVS_FAM[i].Sum();
      chol.Decompose(BOB);

      chol.Invert();
      CovCoef = chol.inv;
      delta2.Dimension(coefCount);
      delta2.Zero();
      for(int i = 0; i < coefCount; i++)
         for(int j = 0; j < coefCount; j++)
            delta2[i] += CovCoef[i][j] * BOY[j];
      coef.Add(delta2);

/*      if(AtBorder){
         newDVD.Dimension(borderIndex.Length(), borderIndex.Length());
         for(int i = 0; i < borderIndex.Length(); i++)
            for(int j = i; j < borderIndex.Length(); j++)
               newDVD[i][j] = newDVD[j][i] = DVD[borderIndex[i]][borderIndex[j]] * 0.5;
         chol.Decompose(newDVD);
         chol.Invert();
         covariance.Dimension(parCount, parCount);
         covariance.Zero();
         for(int i = 0; i < borderIndex.Length(); i++)
            for(int j = 0; j < borderIndex.Length(); j++)
               covariance[borderIndex[i]][borderIndex[j]] = chol.inv[i][j];
      }else{ */
         for(int i = 0; i < parCount; i++)
            for(int j = i; j < parCount; j++)
               DVD[j][i] = DVD[i][j] = DVD[i][j] * 0.5;

         chol.Decompose(DVD);
         chol.Invert();
         covariance = chol.inv;
//      }
      delta.Dimension(parCount);
      delta.Zero();
      for(int i = 0; i < parCount; i++)
         for(int j = 0; j < parCount; j++)
            delta[i] += covariance[i][j] * DVS[j];
      if(deltaScale != 1.0)
         for(int i = 0; i < parCount; i++)
            delta[i] *= deltaScale;
      variances.Add(delta);
      if(constraint()) AtBorder = 1;

//      printf("%d: %G\t%G\t%G\n", loop, delta.SumSquares(), variances[0], variances[1]);
      if(delta.SumSquares() < Epsilon) break;
   }  // end of loop

   Matrix BOB2(coefCount, coefCount);
   BOB2.Zero();
   for(int i = 0; i < coefCount; i++)
      for(int j = 0; j < coefCount; j++)
         for(int f = 0; f < ped.familyCount; f++)
              BOB2[i][j] += BOY_FAM[i][f] * BOY_FAM[j][f];
   CovCoef_R.Dimension(coefCount, coefCount);
   CovCoef_R.Zero();
   for(int i = 0; i < coefCount; i++)
      for(int j = i; j < coefCount; j++){
         for(int u = 0; u < coefCount; u++)
            for(int v = 0; v < coefCount; v++)
               CovCoef_R[i][j] += CovCoef[i][u] * BOB2[u][v] * CovCoef[v][j];
         CovCoef_R[j][i] = CovCoef_R[i][j];
      }

   SEcoef_R.Dimension(coefCount);
   for(int i = 0; i < coefCount; i++){
      if(CovCoef[i][i]>0) SEcoef[i] = sqrt(CovCoef[i][i]);
      else continue;
      if(CovCoef_R[i][i]>0) SEcoef_R[i] = sqrt(CovCoef_R[i][i]);
      else continue;
   }

   Matrix DVD2(parCount, parCount);
   DVD2.Zero();
   for(int i = 0; i < parCount; i++)
      for(int j = 0; j < parCount; j++)
         for(int f = 0; f < ped.familyCount; f++)
              DVD2[i][j] += DVS_FAM[i][f] * DVS_FAM[j][f];
   covariance_R.Dimension(parCount, parCount);
   covariance_R.Zero();
   for(int i = 0; i < parCount; i++)
      for(int j = i; j < parCount; j++){
         for(int u = 0; u < parCount; u++)
            for(int v = 0; v < parCount; v++)
               covariance_R[i][j] += covariance[i][u] * DVD2[u][v] * covariance[v][j];
         covariance_R[j][i] = covariance_R[i][j];
      }
   SEvariances_R.Dimension(parCount);
   for(int i = 0; i < parCount; i++){
      if(covariance[i][i]>0) SEvariances[i] = sqrt(covariance[i][i]);
      else continue;
      if(covariance_R[i][i]>0) SEvariances_R[i] = sqrt(covariance_R[i][i]);
      else continue;
   }


   // MLE stuff
   loglik = 0;
   for (int f = 0; f < ped.familyCount; f++){
      size = pheno[f].Length();
      if(size==0) continue;
      GetPhi(f);
      RefreshO(f);
      buf = traits[f];
      for(int i = 0; i < size; i++)
         for(int j = 0; j < coefCount; j++)
            buf[i] -= coef[j] * covariates[f][j][i];
      CholeskyOmega.Decompose(Omega);
      CholeskyOmega.BackSubst0(buf);
      for(int i = 0; i < size; i++) {
         loglik -= CholeskyOmega.x[i] * CholeskyOmega.x[i] / 2;
         loglik -= log(fabs(CholeskyOmega.L[i][i]));
      }
   }
   summary();
}

   



