//////////////////////////////////////////////////////////////////////
// GEE.h
// Author: Wei-Min Chen
// Oct 10, 2004

#ifndef __VCGEE_H__
#define __VCGEE_H__

#include "Pedigree.h"
#include "IntArray.h"
#include "MathMatrix.h"
#include "MathVector.h"
#include "MathCholesky.h"

class GEE{
protected:
   Vector delta;
   Vector delta2;

   virtual void GetPhi(int f);


   Vector SEvariances, SEvariances_R;
   Matrix covariance;   // variance-covariance matrix of vc
   Matrix covariance_R;


   Vector SEcoef, SEcoef_R;
   Matrix CovCoef;
   Matrix CovCoef_R;

   Cholesky CholeskyOmega;
   Matrix D;            // D for GEE
   Matrix Omega;        // variace-covariance matrix of trait
   Matrix *OD;
   Matrix Phi;
   Matrix Delta;
   int parCount;        // number of variance components
   int coefCount;       // number of regression coefficients
   int size;            // size of score


   inline int Index(int u, int v){
      if(u==v) return u;
      else if(u<v) return size + v*(v-1)/2 + u;
      else return size + u*(u-1)/2 + v;
   }
   virtual void RefreshD(int f){}
   virtual void RefreshO(int f){}
   virtual void RefreshOD(int f);
   void Refresh(int f);
   virtual void InitCoef(){}
   virtual void summary(){}
   virtual int constraint();
public:
   int ValidFamilies;
   int ValidPersons;

   Vector *traits;
   Matrix *covariates;

   double deltaScale;
   int AtBorder;
   IntArray borderIndex;
   Matrix newDVD;

   Vector coef;         // regression coefficients
   Vector variances;    // variance components
   IntArray * pheno;

   int LoopCount;
   double Epsilon;

   double loglik;

   Pedigree & ped;
   GEE(Pedigree & pedigree);
   virtual void print(){}
   virtual void solve();
   virtual ~GEE();
};


#endif
