//////////////////////////////////////////////////////////////////////
// VCLINEAR.cpp
// Author: Wei-Min Chen
// May 13, 2005

#include "VCLinear.h"
#include "Kinship.h"
#include "KinshipX.h"
#include "MathStats.h"
#include <math.h>

// ***************** GEEVC_LINEAR *********************
GEEVC_LINEAR::GEEVC_LINEAR(Pedigree & pedigree):GEE(pedigree)
{
   varianceComponents = NULL;
   personValid.Dimension(pedigree.count);
   personValid.Set(1);
   mCovariate.Dimension(0);
}

GEEVC_LINEAR::~GEEVC_LINEAR()
{
   if(varianceComponents) delete []varianceComponents;
}

double GEEVC_LINEAR::residual(int p)
{
   if(!ped[p].isPhenotyped(trait)) return _NAN_;
   for(int k = 0; k < mCovariate.Length(); k++)
      if(!ped[p].isControlled(mCovariate[k])) return _NAN_;
   double r = ped[p].traits[trait] - coef[0];
   for(int i = 1; i < coef.Length(); i++)
      r -= coef[i] * ped[p].covariates[mCovariate[i-1]];
   return r;
}
 
void GEEVC_LINEAR::init()
{}

void GEEVC_LINEAR::summary()
{

   totalVariance = variances.Sum();

   H2 = variances[1] / totalVariance;

   borderIndex.Dimension(0);

}


void GEEVC_LINEAR::print()

{}


void GEEVC_LINEAR::RefreshOD(int f)

{
   CholeskyOmega.Invert();
   for(int i = 0; i < parCount; i++){
      OD[i] = CholeskyOmega.inv;
      OD[i].Product(CholeskyOmega.inv, varianceComponents[i]);
   }
}

void GEEVC_LINEAR::InitCoef()
{
   if(pheno==NULL) pheno = new IntArray[ped.familyCount];
   if(traits==NULL) traits = new Vector[ped.familyCount];
   if(covariates==NULL) covariates = new Matrix[ped.familyCount];

   for(int f = 0; f < ped.familyCount; f++) {
      pheno[f].Dimension(0);
      for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
         int missing = 0;
         if(!personValid[i]) continue;
         for(int k = 0; k < mCovariate.Length(); k++){
            if(!ped[i].isControlled(mCovariate[k])) {
               missing=1;
               break;
            }
         }
         if(!missing && ped[i].isPhenotyped(trait))
            pheno[f].Push(i);
      }
   }

//   coef.Dimension(ped.covariateCount+1);
   coef.Dimension(mCovariate.Length()+1);
   coefCount = coef.Length();
   ValidFamilies = ValidPersons = 0;
   for (int f = 0; f < ped.familyCount; f++){
      int size = pheno[f].Length();
      traits[f].Dimension(size);
      covariates[f].Dimension(coefCount, size);
      if(size == 0) continue;
      ValidFamilies++;
      ValidPersons += size;
      for(int u = 0; u < size; u++){
         traits[f][u] = ped[pheno[f][u]].traits[trait];
         covariates[f][0][u] = 1;
         for(int i = 1; i < coefCount; i++)
            covariates[f][i][u] = ped[pheno[f][u]].covariates[mCovariate[i-1]];
      }
   }
   parCount = variances.Length();
}

// *********************** POLY ***************************

void POLY::InitCoef()
{
   GEEVC_LINEAR::InitCoef();

   variances.Dimension(2);
   parCount = variances.Length();
   if(varianceComponents==NULL) varianceComponents = new Matrix[parCount];

   double IVY, PVYY, IVI, PVP;
   IVY = PVYY = IVI = PVP = 0;
   Vector XVY(coefCount);
   XVY.Zero();
   Matrix XVX(coefCount, coefCount);
   XVX.Zero();

   for (int f = 0; f < ped.familyCount; f++){
      int size = pheno[f].Length();
      if(size == 0) continue;
      for(int u = 0; u < size; u++)
         for(int i = 0; i < coefCount; i++) {
            XVY[i] += covariates[f][i][u] * traits[f][u];
            for(int j = 0; j < coefCount; j++)
               XVX[i][j] += covariates[f][i][u] * covariates[f][j][u];
         }
   }
   Cholesky chol;
   chol.Decompose(XVX);
   chol.Invert();
   for(int i = 0; i < coefCount; i++){
      coef[i] = 0;
      for(int u = 0; u < coefCount; u++)
         coef[i] += chol.inv[i][u] * XVY[u];
   }

   Kinship kin;
   for (int f = 0; f < ped.familyCount; f++){
      int size = pheno[f].Length();
      Matrix Phi;
      Phi.Dimension(size, size);
      kin.Setup(*ped.families[f]);
      for(int i = 0; i < size; i++)
         for(int j = i; j < size; j++)
            Phi[j][i] = Phi[i][j] = 2 * kin(ped[pheno[f][i]], ped[pheno[f][j]]);

      Vector buf;
      buf.Dimension(0);
      for(int i = 0; i < size; i++){
         double temp = traits[f][i];
         for(int k = 0; k < coefCount; k++)
            temp -= coef[k] * covariates[f][k][i];
         buf.Push(temp);
      }
       for(int i = 0; i < size; i++){
         IVY += buf[i]*buf[i];
         IVI ++;
      }
      for(int u = 0; u < size; u++)
         for(int v = u+1; v < size; v++) {
            PVYY += Phi[u][v] * buf[u] * buf[v];
            PVP += Phi[u][v] * Phi[u][v];
         }
   }
   variances[0] = (IVY - IVI * PVYY / PVP) / IVI;
   if(variances[0]<0) variances[0] =  0.000001;
   variances[1] = PVYY / PVP;
   if(variances[1]<0) variances[1] =  0.000001;

   Epsilon *= variances.Sum() * variances.Sum();
}

void POLY::RefreshO(int f)
{
   Omega.Dimension(size, size);
   for(int i = 0; i < size; i++){
      Omega[i][i] = variances[0] + variances[1];
      for(int j = i+1; j < size; j++)
         Omega[i][j] = Omega[j][i] = Phi[i][j]*variances[1];
   }
}

void POLY::RefreshOD(int f)
{
   CholeskyOmega.Invert();
   OD[0] = CholeskyOmega.inv;
   OD[1].Product(CholeskyOmega.inv, Phi);
}

// ************************** GEEVC_LINKAGE ******************************

void GEEVC_LINKAGE::InitCoef()
{
   GEEVC_LINEAR::InitCoef();
   if(varianceComponents==NULL) varianceComponents = new Matrix[parCount];
}

void GEEVC_LINKAGE::RefreshO(int f)
{
   int k;
   Omega.Dimension(size, size);

   for(int i = 0; i < parCount; i++)
      varianceComponents[i].Dimension(size, size);
   varianceComponents[0].Identity();
   varianceComponents[1] = Phi;

   varianceComponents[2].Identity();
   for(int i = 0; i < size; i++)
      for(int j = 0; j < i; j++)
         varianceComponents[2][i][j] =
            varianceComponents[2][j][i] =
               ibd[f][ped[pheno[f][i]].traverse * ped.families[f]->count + ped[pheno[f][j]].traverse];
   Omega.Zero();
   for(int i = 0; i < size; i++)
      for(int j = 0; j < size; j++)
         for(int k = 0; k < parCount; k++)
            Omega[i][j] += variances[k] * varianceComponents[k][i][j];
}

void GEEVC_LINKAGE::summary()
{

   GEEVC_LINEAR::summary();

   h2 = variances[2] / totalVariance;

}

// *************************** GEEVC_ASSOC *********************

void GEEVC_ASSOC::InitCoef()
{
   personValid.Set(1);
   for(int i = 0; i < ped.count; i++)
      if(IBS[i] == _NAN_){
         personValid[i] = 0;
//         printf("%d ", i);
      }
      
   GEEVC_LINKAGE::InitCoef();

//   coef.Dimension(ped.covariateCount+2);
   coef.Dimension(mCovariate.Length()+2);
   coef[coef.Length()-1] = 0.001;
   coefCount = coef.Length();
   for (int f = 0; f < ped.familyCount; f++){
      int size = pheno[f].Length();
      if(size == 0) continue;
      covariates[f].Dimension(coefCount, size);
      for(int u = 0; u < size; u++){
         covariates[f][0][u] = 1;
         for(int i = 1; i < coefCount-1; i++)
            covariates[f][i][u] = ped[pheno[f][u]].covariates[mCovariate[i-1]];
         for(int i = coefCount-1; i < coefCount; i++){
            covariates[f][i][u] = IBS[pheno[f][u]];
         }
      }
   }
}

void GEEVC_ASSOC::summary()
{

   GEEVC_LINKAGE::summary();

}


 /*
    int k;
   for(int i = 0; i < parCount; i++)
      varianceComponents[i].Dimension(size, size);
   varianceComponents[0].Identity();
   varianceComponents[1] = Phi;
   Omega.Zero();
   for(int i = 0; i < size; i++)
      for(int j = 0; j < size; j++)
         for(int k = 0; k < parCount; k++)
            Omega[i][j] += variances[k] * varianceComponents[k][i][j];
   */

