#ifndef __analysis_h__
#define __analysis_h__

# include "Pedigree.h"
# include "FamilyLikelihood.h"
//# include "AutoFit.h"
# include "VCLinear.h"
# include "elimination.h"
#include "multivar.h"
#include "MultiBalance.h"
#include "BiBalance.h"

#define SCORE1 1
#define SCORE1_R 2

#define OLS 3

#define SCORE2_R 4

#define SCORE3_R 5

#define MLE1 6

#define SCORE_A 7

#define QTDT_AT 8
#define LINKAGE_LRT 9
#define POLYGENIC 10
#define HAPLOTYPE 11

class LikelihoodFrequencySolver:public VectorFunc{
   public:
      FamilyLikelihoodSNP MaxLikEngine;
      Pedigree *ped;
      ES_TRAVERSE * es;
      ES_TRAVERSE * esPerson;
      virtual double Evaluate(Vector &);
      LikelihoodFrequencySolver(){es = esPerson = NULL;}
      virtual ~LikelihoodFrequencySolver(){if(es) delete []es; if(esPerson) delete []esPerson;}
 };

class LikelihoodSolver:public VectorFunc{
   public:
      BiallelicLocus MaxLikEngine;
      Pedigree *ped;
      ES_TRAVERSE * es;
      ES_TRAVERSE * esPerson;
      int dim;
      virtual double Evaluate(Vector &);
      LikelihoodSolver(){es = esPerson = NULL;}
      virtual ~LikelihoodSolver(){if(es) delete []es; if(esPerson) delete []esPerson;}
 };

class AssociationAnalysis{
   protected:
      void AnalysisQTDT(int);
      double ToLOD;
   public:
      AssociationAnalysis(Pedigree &);
      virtual ~AssociationAnalysis();
      void EstimateFrequency();
      void EstimateMLE();
      void GenotypeInfer();

      int performance_twoStage;
      int performance_fast;
      int Approach;
      int WriteFile;
      int noInfer;
      double toleranceVariance;
      double DifferenceInMissing;
      int IntervalMapping;
      int analyticalPower;
      GenotypeElimination * GE;
      FamilyLikelihoodNull * MaxLikEngine;
      FamilyLikelihoodPerson flankingEngine;
      FamilyLikelihoodEff *IBDEngine;
      Vector *ibd;
      int currentFamily;
      int IBDcalculation;
      void MultipointIBD();

      ES_TRAVERSE * es;
      ES_TRAVERSE * esPerson;
      void GetTraverse();

      virtual void SelectLocus(int m, FamilyLikelihoodNull * Engine);

      // Trait model parameters
      String prefix;
      int trait;
      IntArray traits;
      int normalization;
      IntArray covariates;
      double mean;
      double variance;
      double heritability;
      double freq;

      IntArray pheno;

      IntArray flankingCount;

      double missingThreshold;
//      StringArray markerList;    // markers to be tested
      IntArray markerList;
      StringArray traitList;     // traits to be analyzed
      StringArray covariateList; // covariates to be included in the model

      int subjectCount;

      Matrix statistic, pvalue;

      Vector *statArray;

      Vector *pvalueArray;

      IntArray *pvaluePosition;

      Vector *alleleArray;

      void InvNorm(int tr);


      double pvalueLessThan, statisticGreaterThan;

      int GenoLik;

      int printFreq;

      int debugFlag;
      int balanceFlag;
      bool sequentialFlag;

     // Analysis positions
      static int    steps_per_interval;
      static double maxDistance;
      static double minDistance;
      static double grid;
      double stop;
      double start;

      IntArray sparseMap;

      IntArray *denseMap;

      IntArray flankingMap[2];

      // Index between markers in pedigree and markers in the chromosome
      // being analyzed
      IntArray markers;
      int      markerCount;
      Vector   markerPositions;
//      Vector   markerFrequencies;
      Vector   markerMissing;

      // These variables track the currently selected family
      Pedigree & ped;

      int debugPrint;
      int writeIBD;

      // Setup global variables
      virtual void SetupGlobals();

      virtual void pre_genome();
      virtual void post_genome();
      // Setup analysis for the current family
      virtual int SelectFamily(Family * f){return 0;}

      // Print LOD scores at each location
      virtual void PrintScores();
      virtual void PrintSummary();

      // Analyze the currently selected family
      virtual void Analyze();
      void PhaseMarker(int spaseIndex);
      void BuildFlankingMap();

      Matrix means;
      Vector variances;
      Vector heritabilities;
      IntArray SampleSize;
      Matrix VCmeans;
      Vector VCvariances;
      Vector VCheritabilities;
      Vector VCheritabilities1;
      Matrix VCheritabilities2;
      Matrix VCLOD;
      Vector POLYloglik;
      Vector VCloglik;

      POLY *GEEpoly;
      GEEVC_LINKAGE *GEEvc;
      GEEVC_ASSOC *GEEassoc;
      POLY_Multivariate *multiPoly;
      Vector IBS;
      int writeTransformation;
      void vcLinkage(int);

      bool no_chromosome, many_chromosomes;
      Vector peakStatistic, peakPvalue;
      IntArray peakPosition;
      IntArray peakGenomePosition;
      Vector peakGenomePvalue;
      Matrix Residual;
      IntArray *IndexR;
      int scanFlag;
      int multivariateFlag, bivariateFlag;
      int randomSeed;
      int permutationCount;
      Matrix permutationMatrix;
      void WritePermutation();

      void polygenic();
      void PrintPolygenic();
      void MultiPoly();

      void HaploAnalysis();
      IntArray markersInHaplotype;
      String haplotypeFile;
      double rareCutoff;
      int windowSize;
      bool moreFlag;
};

#endif

