// elimination.cpp
// Wei-Min Chen, 9/14/06

#include "elimination.h"

GenotypeElimination::GenotypeElimination(Pedigree &ped)
{
   genotypeList = new IntArray[ped.count];
   sibshipList = new IntArray[ped.familyCount];
   genotypeArray.Dimension(ped.count);
   
   // Create a list of sibships
   for(int f = 0; f < ped.familyCount; f++){
      sibshipList[f].Dimension(0);
      for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
         if(ped[i].sibCount == 0) continue;
         if(ped[i].sibs[0]->serial == i)  // sibship number
            sibshipList[f].Push(i);
      }
   }

   double temp[] =
      {
      /* 0 x 0, AA x AA */   1.0, 0.0, 0.0, 0.0,
      /* 0 x 1, AA x Aa */   0.5, 0.5, 0.0, 0.0,
      /* 0 x 2, AA x aA */   0.5, 0.5, 0.0, 0.0,
      /* 0 x 3, AA x aa */   0.0, 1.0, 0.0, 0.0,
      /* 1 x 0, Aa x AA */   0.5, 0.0, 0.5, 0.0,
      /* 1 x 1, Aa x Aa */   0.25, 0.25, 0.25, 0.25,
      /* 1 x 2, Aa x aA */   0.25, 0.25, 0.25, 0.25,
      /* 1 x 3, Aa x aa */   0.0, 0.5, 0.0, 0.5,
      /* 2 x 0, aA x AA */   0.5, 0.0, 0.5, 0.0,
      /* 2 x 1, aA x Aa */   0.25, 0.25, 0.25, 0.25,
      /* 2 x 2, aA x aA */   0.25, 0.25, 0.25, 0.25,
      /* 2 x 3, aA x aa */   0.0, 0.5, 0.0, 0.5,
      /* 3 x 0, aa x AA */   0.0, 0.0, 1.0, 0.0,
      /* 3 x 1, aa x Aa */   0.0, 0.0, 0.5, 0.5,
      /* 3 x 2, aa x aA */   0.0, 0.0, 0.5, 0.5,
      /* 3 x 3, aa x aa */   0.0, 0.0, 0.0, 1.0
      };


   for(int i = 0; i < 64; i++)
      transmission_matrix[i] = temp[i];

}

GenotypeElimination::~GenotypeElimination(void)
{
   if(genotypeList) delete []genotypeList;
   if(sibshipList) delete []sibshipList;
}

void GenotypeElimination::Run(Pedigree & ped, IntArray & ms)
{
   for(int f = 0; f < ped.familyCount; f++)
      Run(ped, f, ms);
}

void GenotypeElimination::Run(Pedigree & ped, int f, IntArray & ms)
{
   for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++)
      genotypeArray[i].SetLength(ms.Length());
   for(int m = 0; m < ms.Length(); m++){
      Run(ped, f, ms[m]);
      for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
         if(genotypeList[i].Length() == 0){
            genotypeArray[i][m] = 16;
            continue; //error("unexpected empty genotypeList.");
         }
/*
         int temp = genotypeList[i][0];
         for(int g = 1; g < genotypeList[i].Length(); g++)
            temp |= (genotypeList[i][g]<<(g*2));
         genotypeArray[i][m] = (char)temp;
         //e.g., 0x0, 0x0100, 0x100100, 0x11100100
*/
         genotypeArray[i][m] = (1<<genotypeList[i][0]);
         for(int g = 1; g < genotypeList[i].Length(); g++)
            genotypeArray[i][m] |= (1<<genotypeList[i][g]);
      }
   }
}

void GenotypeElimination::Run(Pedigree & ped, int f, int mar)
{
// prepare
   for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
      if(ped[i].markers[mar].Hi()>2) // not SNP;
         error("unexpected high allele.");
      genotypeList[i].Dimension(0);
   }
   for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
      if(ped[i].markers[mar].isKnown()){
         if(ped[i].markers[mar].isHeterozygous()){
            genotypeList[i].Push(1);
            genotypeList[i].Push(2);
         }else{
            if(ped[i].markers[mar][0] == 1) genotypeList[i].Push(0);
            else if(ped[i].markers[mar][0] == 2) genotypeList[i].Push(3);
         }
      }else{
         genotypeList[i].Push(0);
         genotypeList[i].Push(1);
         genotypeList[i].Push(2);
         genotypeList[i].Push(3);
      }
   }

   // analysis
   int traverseFlag = 1;
   IntArray nuclear;
   IntArray Saved[100];
   while(traverseFlag){
      traverseFlag = 0;
      for(int s = 0; s < sibshipList[f].Length(); s++){
         int dad = ped[sibshipList[f][s]].father->serial;
         int mom = ped[sibshipList[f][s]].mother->serial;
         nuclear.Dimension(0);
         nuclear.Push(dad);
         nuclear.Push(mom);
         for(int o = 0; o < ped[sibshipList[f][s]].sibCount; o++)
            nuclear.Push(ped[sibshipList[f][s]].sibs[o]->serial);
         for(int i = 0; i < nuclear.Length(); i++){
            Saved[i].Dimension(genotypeList[nuclear[i]].Length());
            Saved[i].Zero();
         }
         for(int d = 0; d < genotypeList[dad].Length(); d++)
            for(int m = 0; m < genotypeList[mom].Length(); m++){
               int parents = (genotypeList[dad][d]<<4) | (genotypeList[mom][m]<<2);
               int saveFlag = 1;
               for(int o = 0; o < ped[sibshipList[f][s]].sibCount; o++){
                  int saveNow = 0;
                  int kid = ped[sibshipList[f][s]].sibs[o]->serial;
                  for(int k = 0; k < genotypeList[kid].Length(); k++)
                     if(transmission_matrix[parents + genotypeList[kid][k]] > 0.0001)
                        saveNow = 1;
                  if(saveNow==0) {
                     saveFlag = 0;
                     break;
                  }
               }
               if(saveFlag==0) continue; // a parent-child trio is incompatible
               Saved[0][d] = Saved[1][m] = 1;
               for(int o = 0; o < ped[sibshipList[f][s]].sibCount; o++){
                  int kid = ped[sibshipList[f][s]].sibs[o]->serial;
                  for(int k = 0; k < genotypeList[kid].Length(); k++)
                     if(transmission_matrix[parents + genotypeList[kid][k]] > 0.0001)
                        Saved[o+2][k] = 1;
               }
            }
         for(int i = 0; i < nuclear.Length(); i++){
            int p = nuclear[i];
            for(int j = genotypeList[p].Length()-1; j >= 0; j--)
               if(!Saved[i][j]) { // delete j
                  genotypeList[p].Delete(j);
                  traverseFlag = 1;
               }
         }
      }
   }
}

void GenotypeElimination::Run(Pedigree & ped, int mar)
{
   for(int f = 0; f < ped.familyCount; f++)
      Run(ped, f, mar);
}


void GenotypeElimination::Print(Pedigree & ped)
{
   for(int f = 0; f < ped.familyCount; f++)
      Print(ped, f);
}

void GenotypeElimination::Print(Pedigree & ped, int f)
{
   for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
      printf("%d", i);
      if(ped[i].father && ped[i].mother)
         printf(" %d %d", ped[i].father->serial, ped[i].mother->serial);
      else
         printf(" -1 -1");
      printf(" %d", ped[i].sex);
      for(int j = 0; j < genotypeList[i].Length(); j++){
         printf("\t%d", genotypeList[i][j]);
      }
      printf("\n");
   }
}

