#ifndef __HaplotypeAnalysis_h__
#define __HaplotypeAnalysis_h__

#include "Pedigree.h"
#include "MathMatrix.h"
#include "OLS.h"

class HaplotypeAnalysis{
   public:
      Pedigree ped;
      IntArray traits, covariates;
      IntArray markerList;      
      int count;  // number of individuals
      double rareCutoff;

      StringArray Haplotype[2];
      IntArray map;
      IntArray PedToHap;
      IntArray minorAllele;
      Vector alleleFreq;  


      IntArray SNPforHAP;  // all markerList SNPs by default
      IntArray hapCode[2];
      int hapCount;
      Matrix D, Rsquare;

      OLS_REGRESSION ols;
      Vector loglik0, loglik, pvalue, pvalue2;

      int printFlag;

      HaplotypeAnalysis(Pedigree & pedigree);
      void ReadData(const char*);
      void ExploreMarker();
      void PrintSNP();      
      void PrepareHap();
      void regression(int trait);
      void regression0(int trait);
      void regression1(int trait, int tHap);
};

int Increment(IntArray & sequence, int maxCount);

#endif

