//////////////////////////////////////////////////////////////////////
// multivar.h
// Author: Wei-Min Chen
// March 18, 2007

#ifndef __MULTIVARIATE_H__
#define __MULTIVARIATE_H__

#include "Pedigree.h"
#include "IntArray.h"
#include "MathMatrix.h"
#include "MathVector.h"
#include "MathCholesky.h"
#include "VCGEE.h"
#include "VCLinear.h"

class POLY_Multivariate:public GEE{
protected:
   virtual void RefreshO(int f);
   virtual void RefreshOD(int f);
   virtual void GetPhi(int f);
   IntArray * repeat;
   virtual int constraint(void);
   Matrix O[420];  // inverse of Omega, dimension good for 20 traits
   Matrix OP[420]; // inverse of Omega * Phi
   int count;     // size of a family
   Cholesky bi_chol;
   Matrix M;    
   void InitModel();
public:
   POLY **Model;
   int ModelPreset;
   IntArray mTrait;
   IntArray mCovariate;
   int rCount;    // dimension of multivariate trait
   IntArray *Idx;
   IntArray *rStart, *rEnd;
   IntArray *RowOfOne;
   Vector Rho_g;
   Vector Rho_e;
   Vector Rho;
   Vector H2;
   IntArray isBalanced;
   IntArray SampleSize;
   virtual void InitCoef();
   virtual Vector residual(int p);
   void summary();
   void print();
   POLY_Multivariate(Pedigree & pedigree);
   ~POLY_Multivariate();
};


#endif

//   PolygenicModel *M;
//   void init(PolygenicModel & model1, PolygenicModel & model2){M1 = model1; M2 = model2;}
//   String name;
//   double rhoG, rhoE, rho, H2_rho;
//   double seRhoG, seRhoE, seRho, seH2_rho;
