// scoretest.cpp
// 9/26/2006 Wei-Min Chen

#include "scoretest.h"
#include "MathStats.h"
#include "Kinship.h"
#include "MapFunction.h"
#include <math.h>

ScoreTest::ScoreTest(Pedigree & pedigree):AssociationAnalysis(pedigree){}

ScoreTest::~ScoreTest(){}

void ScoreTest::GetPheno(Family *f)
{
   pheno.Dimension(0);
   for (int i = f->first; i <= f->last; i++){
      int missing = 0;
      for(int k = 0; k < ped.covariateCount; k++)
         if(!ped[i].isControlled(k)) { // covariate missing
            missing=1;
            break;
         }
      if(!missing && ped[i].isPhenotyped(trait))
         pheno.Push(i);
   }
}

int ScoreTest::SelectFamily(Family * f)
{
   GetPheno(f);
   MaxLikEngine->pheno = pheno;

   int count = pheno.Length();
   if(count == 0) return 0;
   Omega.Dimension(count, count);
   Phi.Dimension(count, count);
   Kinship kin;
   kin.Setup(*f);
   for(int i = 0; i < pheno.Length(); i++){
      Omega[i][i] = variance;
      Phi[i][i] = kin(ped[pheno[i]], ped[pheno[i]]);
      for(int j = 0; j < i; j++){
         Phi[j][i] = Phi[i][j] = kin(ped[pheno[i]], ped[pheno[j]]);
         Omega[i][j] = Omega[j][i] =
            2 * Phi[i][j] * variance * heritability;
      }
   }

   Resid.Dimension(count);
   for(int i = 0; i < count; i++) {
      Resid[i] = ped[pheno[i]].traits[traits[trait]] - means[trait][0];
      for(int j = 1; j < means[trait].Length(); j++)
         Resid[i] -= means[trait][j] * ped[pheno[i]].covariates[j-1];
   }
   AlleleCount.Dimension(count);
   AlleleCount.Set(_NAN_);
   return 1;
}

void ScoreTest::SetupGlobals()

{

   AssociationAnalysis::SetupGlobals();

   scores.Dimension(traits.Length());

   information.Dimension(traits.Length());

//   if(analyticalPower)

//      AnalyticalInfo.Dimension(traits.Length(), markerCount);

//   AnalyticalInfo.Zero();

   if(statArray==NULL) statArray = new Vector[traits.Length()];

   if(pvalueArray==NULL) pvalueArray = new Vector[traits.Length()];

   if(pvaluePosition==NULL) pvaluePosition = new IntArray[traits.Length()];

   for(int i = 0; i < traits.Length(); i++){

      statArray[i].Dimension(0);

      pvalueArray[i].Dimension(0);

      pvaluePosition[i].Dimension(0);

   }

   if(IBDcalculation){

      VCLOD.Dimension(traits.Length(), markerCount);

      VCLOD.Zero();

   }

   if(Approach==QTDT_AT){

      if(alleleArray == NULL) alleleArray = new Vector[traits.Length()];

      for(int i = 0; i < traits.Length(); i++)

         alleleArray[i].Dimension(0);

   }

}


void ScoreTest::Analyze()
{
   AssociationAnalysis::Analyze();

   if(IBDcalculation){
      VCmeans.Dimension(traits.Length(), ped.covariateCount+1);
      VCvariances.Dimension(traits.Length());
      VCheritabilities1.Dimension(traits.Length());
      VCheritabilities2.Dimension(traits.Length(), markerCount);
      VCheritabilities2.Zero();
      VCheritabilities.Dimension(traits.Length());
      VCloglik.Dimension(traits.Length());
   }
   polygenic();
   
   if(noInfer) {
      NoInferScore();
      return;
   }

   if(GEEvc) delete GEEvc;
   GEEvc = new GEEVC_LINKAGE(ped);

   if(GEEassoc) delete GEEassoc;
   GEEassoc = new GEEVC_ASSOC(ped);

   IBS.Dimension(ped.count);
   IBS.Set(_NAN_);

   if(performance_twoStage && IntervalMapping){
      if(IBDcalculation){
         if(performance_fast==1){
           if(IBDEngine) delete IBDEngine;
           IBDEngine = new FamilyLikelihoodIBD;
         }else{
            if(IBDEngine) delete IBDEngine;
            IBDEngine = new FamilyLikelihoodIBD2;
            if(IBDEngine->genotypeArray==NULL){
               IBDEngine->genotypeArray = new IntArray[ped.count];
               for(int i = 0; i < ped.count; i++)
                  IBDEngine->genotypeArray[i].Dimension(1);
            }
         }
      }
      if(MaxLikEngine->genotypeArray==NULL){
         MaxLikEngine->genotypeArray = new IntArray[ped.count];
         for(int i = 0; i < ped.count; i++)
            MaxLikEngine->genotypeArray[i].Dimension(1);
      }
      for(int k = 0; k < sparseMap.Length()+1; k++){
         if(denseMap[k].Length()==0) continue;
         PhaseMarker(k);
         MaxLikEngine->CopyPhase(&flankingEngine);
         if(performance_fast==1){
            if(IBDcalculation) {
               IBDEngine->CopyPhase(&flankingEngine);
               if(k==0)
                  IBDEngine->positionSNP = markers[sparseMap[0]];
               else if(k==sparseMap.Length())
                  IBDEngine->positionSNP = markers[sparseMap[sparseMap.Length()-1]];
               else
                  IBDEngine->positionSNP = (markers[sparseMap[k-1]] + markers[sparseMap[k]])/2;
               vcLinkage(k);
            }  // End of IBDcalculation
         }  // End of Performance_fast
         for(int u = 0; u < denseMap[k].Length(); u++){
            int m = denseMap[k][u];
            for(int i = 0; i < ped.count; i++)
               MaxLikEngine->genotypeArray[i][0] = GE->genotypeArray[i][m];
            scores.Zero();
            information.Zero();
            if(markerMissing[m]==1) continue;
            MaxLikEngine->positionSNP = markers[m];
            MaxLikEngine->init(&flankingEngine);
            MaxLikEngine->SelectLocus();
            if(IBDcalculation){
               if(performance_fast==1)
                  for(int i = 0; i < traits.Length(); i++){
                     VCheritabilities2[i][m] = VCheritabilities1[i];
                     VCLOD[i][m] = VCLOD[i][sparseMap[k]];
                  }
               else vcLinkage(m);
               if(Approach == LINKAGE_LRT) continue;
            }
            if(noInfer == 0)
               for(int f = 0; f < ped.familyCount; f++){
                  MaxLikEngine->es = es[f];
                  MaxLikEngine->SelectFamily(ped.families[f]);
                  MaxLikEngine->SavedLikelihood = MaxLikEngine->score();
                  currentFamily = f;
                  for(int i = 0; i < ped.families[f]->count; i++)
                     IBS[ped.families[f]->path[i]] = MaxLikEngine->AlleleCount[i];
                  for(trait = 0; trait < traits.Length(); trait++){
                     heritability = heritabilities[trait];
                     variance = variances[trait];
                     if(SelectFamily(ped.families[f])==0) continue;
                     path.Dimension(pheno.Length());
                     for(int i = 0; i < pheno.Length(); i++)
                        path[i] = ped[pheno[i]].traverse;
                     for(int i = 0; i < pheno.Length(); i++)
                        AlleleCount[i] = MaxLikEngine->AlleleCount[path[i]];
                     if(Approach != QTDT_AT)
                        ComputeScore(m);
                  } // End of trait
               } // End of family
            else{
                  for(int i = 0; i < ped.count; i++)
                     if(ped[i].markers[markers[m]].isKnown())
                        IBS[i] = ped[i].markers[markers[m]].countAlleles(2);
                     else IBS[i] = _NAN_;
                  if(Approach != QTDT_AT){
                     for(int i = 0; i < pheno.Length(); i++){
                        if(ped[ped[pheno[i]].traverse].markers[markers[m]].isKnown())
                           AlleleCount[i] = ped[ped[pheno[i]].traverse].markers[markers[m]].countAlleles(2);
                        else AlleleCount[i] = _NAN_;
                     }
                     ComputeScore(m);
                  }
            }
            if(Approach==QTDT_AT) AnalysisQTDT(m);
            else for(trait = 0; trait < traits.Length(); trait++)
               TestStatistic(m);
         }  // End of denseMap
         if((performance_fast==1)&&IBDcalculation)
            for(int i = 0; i < traits.Length(); i++)
               VCLOD[i][sparseMap[k]] = 0;
      }  // End of sparseMap
   }else{   // not two-stage
      if(IBDcalculation){
         if(IBDEngine) delete IBDEngine;
         IBDEngine = new FamilyLikelihoodIBD2;
         if(IBDEngine->genotypeArray==NULL){
            IBDEngine->genotypeArray = new IntArray[ped.count];
            for(int i = 0; i < ped.count; i++)
               IBDEngine->genotypeArray[i].Dimension(1);
         }
         if(MaxLikEngine->genotypeArray==NULL){
            MaxLikEngine->genotypeArray = new IntArray[ped.count];
            for(int i = 0; i < ped.count; i++)
               MaxLikEngine->genotypeArray[i].Dimension(1);
         }
      }

      if(!IntervalMapping) MaxLikEngine->genotypeVector.Dimension(ped.count);
      if(markerList.Length()){
         for(int m = 0; m < markerList.Length(); m++)
            SingleMarker(markerList[m]);
      }else
      for(int m = 0; m < markerCount; m++){
         scores.Zero();
         information.Zero();
         if(markerMissing[m]==1) continue;
//      if(ped.GetMarkerInfo(markers[m])->freq.Length()>3) continue;
         DifferenceInMissing = 0.15;
         SelectLocus(m, MaxLikEngine);
         if(!IntervalMapping)
            for(int i = 0; i < ped.count; i++)
               MaxLikEngine->genotypeVector[i] = GE->genotypeArray[i][m];
         if(IBDcalculation) {
            PhaseMarker(m);
            vcLinkage(m);
            if(Approach == LINKAGE_LRT) continue;
         }
         if(noInfer == 0)
            for(int f = 0; f < ped.familyCount; f++){
               MaxLikEngine->es = es[f];
               MaxLikEngine->SelectFamily(ped.families[f]);
               MaxLikEngine->SavedLikelihood = MaxLikEngine->score();
               for(int i = 0; i < ped.families[f]->count; i++)
                  IBS[ped.families[f]->path[i]] = MaxLikEngine->AlleleCount[i];
               for(trait = 0; trait < traits.Length(); trait++){
                  heritability = heritabilities[trait];
                  variance = variances[trait];

                  if(SelectFamily(ped.families[f])==0) continue;
                  path.Dimension(pheno.Length());
                  int j;
                  for(int i = 0; i < pheno.Length(); i++){
                     for(j = 0; j < ped.families[f]->count; j++)
                        if(ped.families[f]->path[j] == pheno[i]) break;
                     if(j < ped.families[f]->count) path[i] = j;
                  }  // index i for phenotype corresponds index path[i] for genotype
                  for(int i = 0; i < pheno.Length(); i++)
                     AlleleCount[i] = MaxLikEngine->AlleleCount[path[i]];
                  if(Approach != QTDT_AT) ComputeScore(m);
               }
            }
         else{      // something to be fixed here
            IBS.Set(_NAN_);
            for(int i = 0; i < ped.count; i++)
               if(ped[i].markers[markers[m]].isKnown())
                  IBS[i] = ped[i].markers[markers[m]].countAlleles(2);
            if(Approach != QTDT_AT){
               for(int i = 0; i < pheno.Length(); i++)
                  AlleleCount[i] = ped[path[i]].markers[markers[m]].countAlleles(2);
               ComputeScore(m);
            }
         }
         if(Approach==QTDT_AT) AnalysisQTDT(m);
         else
            for(trait = 0; trait < traits.Length(); trait++)
               TestStatistic(m);
      }
   }
}

void ScoreTest::SingleMarker(int m)
{
/*
   if(IBDcalculation){
      if(IBDEngine) delete IBDEngine;
      IBDEngine = new FamilyLikelihoodIBD2;
      if(IBDEngine->genotypeArray==NULL){
         IBDEngine->genotypeArray = new IntArray[ped.count];
         for(int i = 0; i < ped.count; i++)
            IBDEngine->genotypeArray[i].Dimension(1);
      }
      if(MaxLikEngine->genotypeArray==NULL){
         MaxLikEngine->genotypeArray = new IntArray[ped.count];
         for(int i = 0; i < ped.count; i++)
            MaxLikEngine->genotypeArray[i].Dimension(1);
      }
   }

   if(!IntervalMapping) MaxLikEngine->genotypeVector.Dimension(ped.count);
*/
   scores.Zero();
   information.Zero();
   if(markerMissing[m]==1) return;
   DifferenceInMissing = 0.15;
   SelectLocus(m, MaxLikEngine);
   if(!IntervalMapping)
      for(int i = 0; i < ped.count; i++)
         MaxLikEngine->genotypeVector[i] = GE->genotypeArray[i][m];
   if(IBDcalculation) {
      PhaseMarker(m);
      vcLinkage(m);
      if(Approach == LINKAGE_LRT) return;
   }
   if(noInfer == 0)
      for(int f = 0; f < ped.familyCount; f++){
         MaxLikEngine->es = es[f];
         MaxLikEngine->SelectFamily(ped.families[f]);
         MaxLikEngine->SavedLikelihood = MaxLikEngine->score();
         for(int i = 0; i < ped.families[f]->count; i++)
            IBS[ped.families[f]->path[i]] = MaxLikEngine->AlleleCount[i];
         for(trait = 0; trait < traits.Length(); trait++){
            heritability = heritabilities[trait];
            variance = variances[trait];

            if(SelectFamily(ped.families[f])==0) continue;
            path.Dimension(pheno.Length());
            int j;
            for(int i = 0; i < pheno.Length(); i++){
               for(j = 0; j < ped.families[f]->count; j++)
                  if(ped.families[f]->path[j] == pheno[i]) break;
               if(j < ped.families[f]->count) path[i] = j;
            }  // index i for phenotype corresponds index path[i] for genotype
            for(int i = 0; i < pheno.Length(); i++)
               AlleleCount[i] = MaxLikEngine->AlleleCount[path[i]];
            if(Approach != QTDT_AT) ComputeScore(m);
         }
      }
   else{      // something to be fixed here
      IBS.Set(_NAN_);
      for(int i = 0; i < ped.count; i++)
         if(ped[i].markers[markers[m]].isKnown())
            IBS[i] = ped[i].markers[markers[m]].countAlleles(2);
      if(Approach != QTDT_AT){
         for(int i = 0; i < pheno.Length(); i++)
            AlleleCount[i] = ped[path[i]].markers[markers[m]].countAlleles(2);
         ComputeScore(m);
      }
   }
   if(Approach==QTDT_AT) AnalysisQTDT(m);
   else
      for(trait = 0; trait < traits.Length(); trait++)
         TestStatistic(m);
}

void AssociationAnalysis::AnalysisQTDT(int m)
{
   if(GEEassoc->ibd==NULL) GEEassoc->ibd = new Vector[ped.familyCount];
   for(int f = 0; f < ped.familyCount; f++)
      GEEassoc->ibd[f] = ibd[f];
   GEEassoc->IBS.Dimension(ped.count);
   GEEassoc->IBS = IBS;

   for(trait = 0; trait < traits.Length(); trait++){
      GEEassoc->trait = traits[trait];
      GEEassoc->variances.Dimension(3);
      GEEassoc->variances[0] = VCvariances[trait] * (1-VCheritabilities[trait]-VCheritabilities2[trait][m]);
      GEEassoc->variances[1] = VCvariances[trait] * VCheritabilities[trait];
      GEEassoc->variances[2] = VCvariances[trait] * VCheritabilities2[trait][m];
      GEEassoc->coef = VCmeans[trait];
      GEEassoc->coef.Dimension(VCmeans[trait].Length()+1);
      GEEassoc->AtBorder = 0;
      GEEassoc->solve();
      if(GEEassoc->AtBorder) GEEassoc->solve();
      double temp = GEEassoc->coef[GEEassoc->coef.Length()-1];
      double myAlleleEffect = ped.GetMarkerInfo(markers[m])->freq[1] *
         (1-ped.GetMarkerInfo(markers[m])->freq[1]) * 2 * temp * temp;
      myAlleleEffect /= (GEEassoc->variances.Sum() + myAlleleEffect);
      double myStat = (GEEassoc->loglik - VCloglik[trait]) * 2;
      double myPValue=1.0;

      if(myStat > 1E-100)
         myPValue = chidist(myStat, 1);

      if(myPValue < peakPvalue[trait]){
         peakPvalue[trait] = myPValue;
         peakPosition[trait] = m;
         peakStatistic[trait] = myStat;
      }
      if(myPValue < pvalueLessThan){
         pvalueArray[trait].Push(myPValue);
         statArray[trait].Push(myStat);
         pvaluePosition[trait].Push(m);
         alleleArray[trait].Push(myAlleleEffect);
      }
   }
}

void ScoreTest::PrintScores()
{
//   PrintPolygenic();
   if(Approach == LINKAGE_LRT){
      for(trait = 0; trait < traits.Length(); trait++){
         printf("\nPhenotype: %s [VC] (%d families, h2 = %5.2f%%)\n",
            (const char*)ped.traitNames[traits[trait]],
            ped.familyCount, heritabilities[trait]*100);
         printf("=======================================================\n");
         printf("%20s%8s%8s%8s\n", "Position", "H2", "LOD", "pvalue");

         for(int m = 0; m < markerCount; m++)
            printf("%20f%7.1f%%%8.2f%8.2G\n",
               ped.GetMarkerInfo(markers[m])->position*100, VCheritabilities2[trait][m]*100,
               VCLOD[trait][m],

               VCLOD[trait][m] > 0 ? ndist(sqrt(VCLOD[trait][m] / ToLOD)): 1.0);

      }

      return;
   }

   for(trait = 0; trait < traits.Length(); trait++){
      subjectCount = 0;
      for (int i = 0; i < ped.count; i++)
         if(ped[i].traits[traits[trait]] != _NAN_ ) subjectCount++;

      double LOD;
      printf("\nPedigree-Wide Association Analysis of %s (%d individuals)\n"
          "======================================================================\n",
         (const char*)ped.traitNames[traits[trait]], subjectCount);
      if(Approach == QTDT_AT){
         printf("%10s%7s%7s%8s%15s%7s%7s%8s\n",
            "Position", "H2", "VC_LOD", "VC_pval",
            "Marker", "Effect", "LOD", "pvalue");
      }else{
         printf("%10s%7s%10s%15s", "Position", "LOD", "pvalue", "Marker");

//         if(analyticalPower) printf("%7s", "ELOD");
         if(IBDcalculation) printf("%8s", "LOC_VC");
         printf("\n");
      }

      for(int i = 0; i < pvalueArray[trait].Length(); i++){
         int m = pvaluePosition[trait][i];
//         if(analyticalPower)
//            AnalyticalInfo[trait][m] = AnalyticalInfo[trait][m] * 2 * 0.05 * variance + 1;
         if(pvalueArray[trait][i] > pvalueLessThan) continue;
         LOD = statArray[trait][i] * ToLOD;
         if(Approach == QTDT_AT){
            double VC_pvalue = VCLOD[trait][m]>0? ndist(sqrt(VCLOD[trait][m] / ToLOD)): 1.0;
//            if(VC_pvalue == 1.0) continue;
            printf("%10f%6.1f%%%7.2f%8.2G%15s%6.1f%%%7.2f%8.2G\n",
               ped.GetMarkerInfo(markers[m])->position * 100,
               VCheritabilities2[trait][m] * 100, VCLOD[trait][m], VC_pvalue,
               (const char*)ped.GetMarkerInfo(markers[m])->name,
               alleleArray[trait][i] * 100, LOD, pvalueArray[trait][i]);

         }else{
            if((pvalueLessThan > 0.1) && (pvalueArray[trait][i]>0.0001))
               printf("%10f%7.2f%10.5f%15s", ped.GetMarkerInfo(markers[m])->position*100,
               LOD, pvalueArray[trait][i], (const char*)ped.GetMarkerInfo(markers[m])->name);
            else
               printf("%10f%7.2f%10.2G%15s", ped.GetMarkerInfo(markers[m])->position*100,
               LOD, pvalueArray[trait][i], (const char*)ped.GetMarkerInfo(markers[m])->name);
//            if(analyticalPower) printf("%7.2f", AnalyticalInfo[trait][m] * 0.2171472409516);
            if(IBDcalculation) printf("%8.3f", VCLOD[trait][m]);
            printf("\n");
         }
      }
   }
   PrintSummary();
}

double ScoreTest::TestStatistic(int m)
{
   double myStat, myPValue = 1;
   if(fabs(information[trait]) > 1e-100)
      myStat = scores[trait] * scores[trait] / information[trait];
   else
      myStat = -1;
   if(myStat > 1e-100)
      myPValue = chidist(myStat, 1);
   if(myPValue < peakPvalue[trait]){
      peakPvalue[trait] = myPValue;
      peakPosition[trait] = m;
      peakStatistic[trait] = myStat;
   }
//   if(myPValue < pvalueSummary){
   if(myPValue < pvalueLessThan){
      pvalueArray[trait].Push(myPValue);
      statArray[trait].Push(myStat);
      pvaluePosition[trait].Push(m);
   }
   return myStat;
}

void ScoreTest::ComputeScore(int m)
{
   Cholesky CholeskyOmega;

   Matrix newOmega = Omega;
   if(IBDcalculation){
      int CountInFamily = ped.families[currentFamily]->count;
      for(int i = 0; i < pheno.Length(); i++){
         newOmega[i][i] = VCvariances[trait];
         for(int j = 0; j < i; j++)
            newOmega[i][j] = newOmega[j][i] =
               2 * Phi[i][j] * VCvariances[trait] * VCheritabilities[trait] +
                  ibd[currentFamily][path[i]*CountInFamily+path[j]] *
                  VCvariances[trait] * VCheritabilities2[trait][m];
      }
   }

   CholeskyOmega.Decompose(newOmega);

   Vector temp = AlleleCount;
   temp.Add(-2*(1-ped.GetMarkerInfo(markers[m])->freq[1]));
   CholeskyOmega.BackSubst0(temp);
   temp = CholeskyOmega.x;

   Vector newResid = Resid;
   if(IBDcalculation)
      for(int i = 0; i < pheno.Length(); i++){
         newResid[i] = ped[pheno[i]].traits[traits[trait]] - VCmeans[trait][0];
         for(int j = 1; j < VCmeans[trait].Length(); j++)
            newResid[i] -= VCmeans[trait][j] * ped[pheno[i]].covariates[j-1];
      }
   CholeskyOmega.BackSubst0(newResid);

   score_fam = temp.InnerProduct(CholeskyOmega.x);

   if(Approach == SCORE1){
      info_fam = temp.InnerProduct(temp);
   }else if(Approach == SCORE2_R){
      info_fam = score_fam * score_fam;
   }else if(Approach == SCORE_A){
      CholeskyOmega.BackSubst(newResid);
      Matrix tempMatrix = Phi;
      if(IBDcalculation==0)
         tempMatrix.Multiply(4 * ped.GetMarkerInfo(markers[m])->freq[1] * (1-ped.GetMarkerInfo(markers[m])->freq[1]));
      else{
         int CountInFamily = ped.families[currentFamily]->count;
         for(int i = 0; i < newResid.Length(); i++)
            for(int j = 0; j <= i; j++)
               tempMatrix[i][j] = tempMatrix[j][i] = 2.0 *
                  ped.GetMarkerInfo(markers[m])->freq[1] *
                  (1-ped.GetMarkerInfo(markers[m])->freq[1]) *
                  ibd[currentFamily][path[i]*CountInFamily+path[j]];
      }
      temp.Zero();
      for(int i = 0; i < newResid.Length(); i++)
         for(int j = 0; j < newResid.Length(); j++)
            temp[i] += tempMatrix[i][j] * CholeskyOmega.x[j];
      info_fam = temp.InnerProduct(CholeskyOmega.x);
   }else{   // SCORE1_R
      CholeskyOmega.BackSubst(newResid);
      Matrix tempMatrix = Phi;
      tempMatrix.Multiply(4 * ped.GetMarkerInfo(markers[m])->freq[1] * (1-ped.GetMarkerInfo(markers[m])->freq[1]));
      for(int i = 0; i < newResid.Length(); i++)
         for(int j = 0; j <= i; j++)
            tempMatrix[i][j] = tempMatrix[j][i] =
               tempMatrix[i][j] - MaxLikEngine->AlleleCovariance[path[i]][path[j]];
      temp.Zero();
      for(int i = 0; i < newResid.Length(); i++)
         for(int j = 0; j < newResid.Length(); j++)
            temp[i] += tempMatrix[i][j] * CholeskyOmega.x[j];
      info_fam = temp.InnerProduct(CholeskyOmega.x);
   }
   scores[trait] += score_fam;
   information[trait] += info_fam;

/*   if(analyticalPower)
      for(int i = 0; i < pheno.Length(); i++){
         CholeskyOmega.BackSubst(Phi[i]);
         AnalyticalInfo[trait][m] += CholeskyOmega.x[i];
      }
*/
}

void ScoreTest::NoInferScore()
{
   Cholesky CholeskyOmega;
   Kinship kin;
   Vector tempVector;

   for(int m = 0; m < markerCount; m++){
      if(markerList.Length())
         if(markerList.Find(markers[m])==-1) continue;
      if(markerMissing[m]==1) continue;
      for(trait = 0; trait < traits.Length(); trait++){
         scores[trait] = information[trait] = 0;
         for(int f = 0; f < ped.familyCount; f++){
            AlleleCount.Dimension(0);
            pheno.Dimension(0);
            for(int i = ped.families[f]->first; i <= ped.families[f]->last; i++){
               int missing = 0;
               for(int k = 0; k < ped.covariateCount; k++)
                  if(!ped[i].isControlled(k)) { // covariate missing
                     missing = 1;
                     break;
                  }
               if(!ped[i].markers[m].isKnown())
                  missing = 1;
               if(!missing && ped[i].isPhenotyped(traits[trait])){
                  pheno.Push(i);
                  AlleleCount.Push(ped[i].markers[markers[m]].countAlleles(2));
               }
            }
            int count = pheno.Length();
            if(count == 0) continue;
            Omega.Dimension(count, count);
            Phi.Dimension(count, count);

            kin.Setup(*ped.families[f]);
            for(int i = 0; i < pheno.Length(); i++){
               Omega[i][i] = variances[trait];
               Phi[i][i] = kin(ped[pheno[i]], ped[pheno[i]]);
               for(int j = 0; j < i; j++){
                  Phi[j][i] = Phi[i][j] = kin(ped[pheno[i]], ped[pheno[j]]);
                  Omega[i][j] = Omega[j][i] =
                     2 * Phi[i][j] * variances[trait] * heritabilities[trait];
               }
            }

            Resid.Dimension(count);
            for(int i = 0; i < count; i++) {
               Resid[i] = ped[pheno[i]].traits[traits[trait]] - means[trait][0];
               for(int j = 1; j < means[trait].Length(); j++)
                  Resid[i] -= means[trait][j] * ped[pheno[i]].covariates[j-1];
            }
            CholeskyOmega.Decompose(Omega);

            AlleleCount.Add(-2*(1-ped.GetMarkerInfo(markers[m])->freq[1]));

            CholeskyOmega.BackSubst0(AlleleCount);
            tempVector = CholeskyOmega.x;
            CholeskyOmega.BackSubst0(Resid);
            if(Approach == SCORE1){
               scores[trait] += tempVector.InnerProduct(CholeskyOmega.x);
               information[trait] += tempVector.InnerProduct(tempVector);
            }else if(Approach == SCORE_A){
               scores[trait] += tempVector.InnerProduct(CholeskyOmega.x);
               CholeskyOmega.BackSubst(Resid);
               Phi.Multiply(4 * ped.GetMarkerInfo(markers[m])->freq[1] * (1-ped.GetMarkerInfo(markers[m])->freq[1]));
               tempVector.Zero();
               for(int i = 0; i < Resid.Length(); i++)
                  for(int j = 0; j < Resid.Length(); j++)
                     tempVector[i] += Phi[i][j] * CholeskyOmega.x[j];
               information[trait] += tempVector.InnerProduct(CholeskyOmega.x);
            }
         }

         double myStat, myPValue;
         if(fabs(information[trait]) > 1e-100)
            myStat = scores[trait] * scores[trait] / information[trait];
         else
            myStat = -1;

         if(myStat > 1e-100)
            myPValue = chidist(myStat, 1);
         if(myPValue < peakPvalue[trait]){
            peakPvalue[trait] = myPValue;
            peakPosition[trait] = m;
            peakStatistic[trait] = myStat;
         }
         if(myPValue < pvalueLessThan){
            pvalueArray[trait].Push(myPValue);
            statArray[trait].Push(myStat);
            pvaluePosition[trait].Push(m);
         }
      }
   }
}















// ******************** TRASH ****************************
   /*
   printf("\nProportion of significant tests:\n");
   printf("=========================================\n");
   printf("%20s%20s\n", "Significance Level", "#tests / #SNPs");
   printf("%20.3lf%20.4lf\n", 0.05, (1 - (double)pvalue.CountIfGreater(.05) / pvalue.CountIfGreater(-0.5)) );
   printf("%20.3lf%20.4lf\n", 0.01, (1 - (double)pvalue.CountIfGreater(.01) / pvalue.CountIfGreater(-0.5)) );
   printf("%20.3lf%20.4lf\n", 0.001, (1 - (double)pvalue.CountIfGreater(.001) / pvalue.CountIfGreater(-0.5)) );
     */
/*
   printf("\nThe smallest p-value is %.3G, at %G cM, chromosome %d,\n     between SNP %s and phenotype %s.\n",
      min, ped.GetMarkerInfo(t)->position*100, ped.GetMarkerInfo(t)->chromosome,
      (const char*)ped.GetMarkerInfo(t)->name, (const char*)ped.traitNames[trait]);
*/
      /*{
         if(GEEassoc->ibd==NULL) GEEassoc->ibd = new Vector[ped.familyCount];
         for(int f = 0; f < ped.familyCount; f++)
            GEEassoc->ibd[f] = ibd[f];
         GEEassoc->IBS.Dimension(ped.count);
         GEEassoc->IBS = IBS;
         for(trait = 0; trait < traits.Length(); trait++){
            GEEassoc->trait = traits[trait];
            GEEassoc->variances.Dimension(3);
            GEEassoc->variances[0] = VCvariances[trait] * (1-VCheritabilities[trait]-VCheritabilities2[trait][m]);
            GEEassoc->variances[1] = VCvariances[trait] * VCheritabilities[trait];
            GEEassoc->variances[2] = VCvariances[trait] * VCheritabilities2[trait][m];
            GEEassoc->coef = VCmeans[trait];
            GEEassoc->coef.Dimension(VCmeans[trait].Length()+1);
            GEEassoc->AtBorder = 0;
            GEEassoc->solve();
            if(GEEassoc->AtBorder) GEEassoc->solve();

//            printf("%f\t%f\t%f\t%f\t%f\t%f\n", (GEEassoc->loglik - VCloglik[trait]) / log(10.0),
//            GEEassoc->coef[1], GEEassoc->coef[0], GEEassoc->totalVariance, GEEassoc->H2, GEEassoc->h2);
            AlleleEffect[trait][m] = GEEassoc->coef[GEEassoc->coef.Length()-1];
            statistic[trait][m] = (GEEassoc->loglik - VCloglik[trait]) * 2;
            if(statistic[trait][m] < 1E-100){
               statistic[trait][m] = 0;
               AlleleEffect[trait][m] = 0;
            }
         }  // End of QTDT_AT
      }*/
               /*
               {
                  if(GEEassoc->ibd==NULL) GEEassoc->ibd = new Vector[ped.familyCount];
                  for(int f = 0; f < ped.familyCount; f++)
                     GEEassoc->ibd[f] = ibd[f];
                  GEEassoc->IBS.Dimension(ped.count);
                  GEEassoc->IBS = IBS;
                  for(trait = 0; trait < traits.Length(); trait++){
                     GEEassoc->trait = traits[trait];
                     GEEassoc->variances.Dimension(3);
                     GEEassoc->variances[0] = VCvariances[trait] * (1-VCheritabilities[trait]-VCheritabilities2[trait][m]);
                     GEEassoc->variances[1] = VCvariances[trait] * VCheritabilities[trait];
                     GEEassoc->variances[2] = VCvariances[trait] * VCheritabilities2[trait][m];
                     GEEassoc->coef = VCmeans[trait];
                     GEEassoc->coef.Dimension(VCmeans[trait].Length()+1);
                     GEEassoc->AtBorder = 0;
                     GEEassoc->solve();
                     if(GEEassoc->AtBorder) GEEassoc->solve();
//                     printf("%f\t%f\t%f\t%f\t%f\t%f\n", (GEEassoc->loglik - VCloglik[trait]) / log(10.0),
//                        GEEassoc->coef[1], GEEassoc->coef[0], GEEassoc->totalVariance, GEEassoc->H2, GEEassoc->h2);
                     AlleleEffect[trait][m] = GEEassoc->coef[GEEassoc->coef.Length()-1];
                     statistic[trait][m] = (GEEassoc->loglik - VCloglik[trait]) * 2;
                     if(statistic[trait][m] < 1E-100){
                        statistic[trait][m] = 0;
                        AlleleEffect[trait][m] = 0;
                     }
                  }
               }*/
                    /*
                     IBDEngine->positionSNP = markers[m];
                     IBDEngine->init(&flankingEngine);
                     IBDEngine->SelectLocus();
                     MultipointIBD();
                     // GEEvc here.
                     for(int i = 0; i < traits.Length(); i++){
                        GEEvc->trait = traits[i];
                        if(GEEvc->ibd==NULL) GEEvc->ibd = new Vector[ped.familyCount];
                        for(int f = 0; f < ped.familyCount; f++)
                           GEEvc->ibd[f] = ibd[f];
                        GEEvc->variances.Dimension(3);
                        GEEvc->variances[0] = variances[i] * (1-heritabilities[i]);
                        GEEvc->variances[1] = variances[i] * heritabilities[i];
                        GEEvc->variances[2] = 0;
                        GEEvc->coef = means[i];
                        GEEvc->AtBorder = 0;
                        GEEvc->solve();
                        if(GEEvc->AtBorder) GEEvc->solve();
                        VCloglik[i] = GEEvc->loglik;
                        VCLOD[i][m] = (VCloglik[i] - POLYloglik[i]) / log(10.0);
                        if(VCLOD[i][m] < 1E-100){
                           VCLOD[i][m]= 0;
                           VCmeans[i] = means[i];
                           VCvariances[i] = variances[i];
                           VCheritabilities[i] = heritabilities[i];
                           VCheritabilities2[i][m] = 0;
                           VCloglik[i] = POLYloglik[i];
                        }else{
                           VCmeans[i] = GEEvc->coef;
                           VCvariances[i] = GEEvc->totalVariance;
                           VCheritabilities[i] = GEEvc->H2;
                           VCheritabilities2[i][m] = GEEvc->h2;
                        }
                     */
/*
               IBDEngine->init(&flankingEngine);
               IBDEngine->SelectLocus();
               MultipointIBD();

               // GEEvc here.
               for(int i = 0; i < traits.Length(); i++){
                  GEEvc->trait = traits[i];
                  if(GEEvc->ibd==NULL) GEEvc->ibd = new Vector[ped.familyCount];
                  for(int f = 0; f < ped.familyCount; f++)
                     GEEvc->ibd[f] = ibd[f];
                  GEEvc->variances.Dimension(3);
                  GEEvc->variances[0] = variances[i] * (1-heritabilities[i]);
                  GEEvc->variances[1] = variances[i] * heritabilities[i];
                  GEEvc->variances[2] = 0;
                  GEEvc->coef = means[i];
                  GEEvc->AtBorder = 0;
                  GEEvc->solve();
                  if(GEEvc->AtBorder) GEEvc->solve();
                  VCloglik[i] = GEEvc->loglik;
                  VCLOD[i][sparseMap[k]] = (VCloglik[i] - POLYloglik[i]) / log(10.0);
                  if(VCLOD[i][sparseMap[k]] < 1E-100){
                     VCLOD[i][sparseMap[k]]= 0;
                     VCmeans[i] = means[i];
                     VCvariances[i] = variances[i];
                     VCheritabilities[i] = heritabilities[i];
                     VCheritabilities1[i] = 0;
                     VCloglik[i] = POLYloglik[i];
                  }else{
                     VCmeans[i] = GEEvc->coef;
                     VCvariances[i] = GEEvc->totalVariance;
                     VCheritabilities[i] = GEEvc->H2;
                     VCheritabilities1[i] = GEEvc->h2;
                  }
               }  // End of Trait
               */

       /*
      if(MaxLikEngine->esPerson==NULL)
         MaxLikEngine->esPerson = new ES_TRAVERSE[ped.count];
      for(int i = 0; i < ped.count; i++)
         MaxLikEngine->esPerson[i] = esPerson[i];
         */
/*
void ScoreTest::PrintScores()
{
   const double ToLOD = 0.2171472409516;
   pvalue.Set(1.0);

   printf("\nFitted Polygenic Models\n");
   printf("=====================================================\n");
   printf("%20s%10s%13s%10s", "Trait", "Variance", "Heritability", "Mean");
   for(int i = 0; i < ped.covariateCount; i++)
      printf("%10s", (const char*)ped.covariateNames[i]);
   printf("\n");
   for(trait = 0; trait < traits.Length(); trait++){
      printf("%20s%10.3f%12.1f%%", (const char*)ped.traitNames[traits[trait]],
         variances[trait], heritabilities[trait]*100);
      for(int i = 0; i < means[trait].Length(); i++)
         printf("%10.3f", means[trait][i]);
      printf("\n");
   }
   if(Approach == LINKAGE_LRT){
      for(trait = 0; trait < traits.Length(); trait++){
         printf("\nPhenotype: %s [VC] (%d families, h2 = %5.2f%%)\n",
            (const char*)ped.traitNames[traits[trait]],
            ped.familyCount, heritabilities[trait]*100);
         printf("=======================================================\n");
         printf("%20s%8s%8s%8s\n", "Position", "H2", "LOD", "pvalue");

         for(int m = 0; m < markerCount; m++)
            printf("%20f%7.1f%%%8.2f%8.2G\n",
               ped.GetMarkerInfo(markers[m])->position*100, VCheritabilities2[trait][m]*100,
               VCLOD[trait][m],

               VCLOD[trait][m] > 0 ? ndist(sqrt(VCLOD[trait][m] / ToLOD)): 1.0);

      }
      return;
   }

   for(trait = 0; trait < traits.Length(); trait++){
      subjectCount = 0;
      for (int i = 0; i < ped.count; i++)
         if(ped[i].traits[traits[trait]] != _NAN_ ) subjectCount++;

      double LOD;
      printf("\nPedigree-Wide Association Analysis of %s (%d individuals)\n"
          "======================================================================\n",
         (const char*)ped.traitNames[traits[trait]], subjectCount);
      if(Approach == QTDT_AT){
         printf("%10s%7s%7s%8s%15s%7s%7s%8s\n",
            "Position", "H2", "VC_LOD", "pvalue",
            "Marker", "Effect", "LOD", "pvalue");
      }else{
          printf("%10s%7s%10s%15s", "Position", "LOD", "pvalue", "Marker");

         if(analyticalPower) printf("%7s", "ELOD");
//      if(Approach == QTDT_AT) printf("%7s", "Effect");
         if(IBDcalculation) printf("%8s", "LOC_VC");
         printf("\n");
      }
      for(int i = 0; i < markerCount; i++){
         if(analyticalPower)
            AnalyticalInfo[trait][i] = AnalyticalInfo[trait][i] * 2 * 0.05 * variance + 1;
         if(statistic[trait][i] < 1E-100){
            pvalue[trait][i] = 1;
            LOD = 0;
         }else{
            pvalue[trait][i] = chidist(statistic[trait][i], 1);
            LOD = statistic[trait][i] * ToLOD;
         }
         if(pvalue[trait][i] > pvalueLessThan) continue;
         if(Approach == QTDT_AT)
            printf("%10f%6.1f%%%7.2f%8.2G%15s%6.1f%%%7.2f%8.2G\n",
               ped.GetMarkerInfo(markers[i])->position * 100,
               VCheritabilities2[trait][i] * 100,
               VCLOD[trait][i],
               VCLOD[trait][i]>0? ndist(sqrt(VCLOD[trait][i] / ToLOD)): 1.0,
               (const char*)ped.GetMarkerInfo(markers[i])->name,
               AlleleEffect[trait][i] * 100, LOD, pvalue[trait][i]);
         else{
            printf("%10f%7.2f%10.2G%15s", ped.GetMarkerInfo(markers[i])->position*100,
               LOD, pvalue[trait][i], (const char*)ped.GetMarkerInfo(markers[i])->name);
            if(analyticalPower) printf("%7.2f", AnalyticalInfo[trait][i] * 0.2171472409516);
            if(IBDcalculation) printf("%8.3f", VCLOD[trait][i]);
            printf("\n");
         }
      }
   }
   PrintSummary();
}
*/

/*
   if(GEEpoly==NULL) GEEpoly = new GEEVC_POLY(ped);
   for(int i = 0; i < traits.Length(); i++){
      GEEpoly->trait = traits[i];
      GEEpoly->solve();
      double oldLoglik = GEEpoly->loglik;
      double oldScale = GEEpoly->deltaScale;
      if(GEEpoly->AtBorder){
         GEEpoly->deltaScale *= 0.5;
         GEEpoly->solve();
         if(GEEpoly->loglik < oldLoglik - 0.001){
            GEEpoly->deltaScale = oldScale;
            GEEpoly->AtBorder = 0;
            GEEpoly->solve();
         }
         GEEpoly->deltaScale = oldScale;
         GEEpoly->AtBorder = 0;
      }
      means[i] = GEEpoly->coef;
      variances[i] = GEEpoly->totalVariance;
      heritabilities[i] = GEEpoly->H2;
      POLYloglik[i] = GEEpoly->loglik;
   }
*/

