#ifndef __SCORETEST_H__
#define __SCORETEST_H__

#include "Pedigree.h"
#include "Kinship.h"
#include "MathCholesky.h"
#include "analysis.h"
#include "FamilyLikelihood.h"
#include "MathVector.h"


class ScoreTest:public AssociationAnalysis{
   public:
      ScoreTest(Pedigree & pedigree);
      virtual ~ScoreTest();

//      AutoFit poly;

      virtual void SetupGlobals();

      virtual int SelectFamily(Family * f);
      virtual void Analyze();
      virtual void PrintScores(/*int trait*/);
      virtual void ComputeScore(int m);
      virtual double TestStatistic(int m);
      void CountAllele();
      void GetPheno(Family * f);
      void NoInferScore();
      void SingleMarker(int m);
      
   protected:
      Vector AlleleCount;
//      Matrix scores, information, AnalyticalInfo;
      Vector scores, information;
      Matrix AnalyticalInfo;

      // for each family
      Matrix Omega;
      Matrix Phi;
      Vector Resid;
      IntArray path;

      double score_fam, info_fam;
};

#endif

