#include "AlleleTools.h"

#include <stdlib.h>
#include <ctype.h>

char FlipAllele(char allele)
   {
   switch (allele)
      {
      case 'A': case 'a' : return 'T';
      case 'T': case 't' : return 'A';
      case 'C': case 'c' : return 'G';
      case 'G': case 'g' : return 'C';
      }

   return allele;
   }

char TranslateGenotype(char a1, char a2, char & allele1, char & allele2, char * & error)
   {
   error = NULL;

   int al1 = TranslateAllele(a1, allele1, allele2);
   int al2 = TranslateAllele(a2, allele1, allele2);

   if (al1 == __HEMIZYGOTE_ALLELE__ && al2 == __HEMIZYGOTE_ALLELE__)
      {
      error = "No valid allele";
      return 0;
      }
   else if (al1 == __HEMIZYGOTE_ALLELE__)
      al1 = al2;
   else if (al2 == __HEMIZYGOTE_ALLELE__)
      al2 = al1;

   if (al1 == __THIRD_SNP_ALLELE__ || al2 == __THIRD_SNP_ALLELE__)
      {
      error = "More than 2 different marker alleles listed";
      return 0;
      }

   if ((al1 == 0) ^ (al2 == 0))
      {
      error = "Invalid genotype code found";
      return 0;
      }

   if ((al1 == __INVALID_ALLELE__) || (al2 == __INVALID_ALLELE__))
      {
      error = "Invalid allele code found";
      return 0;
      }

   return al1 | al2;
   }

char TranslateAllele(char al, char & allele1, char & allele2)
   {
   al = toupper(al);

   if (al == 'N')
      return 0;

   if (al == 'X' || al == 'Y' || al == '0')
      return __HEMIZYGOTE_ALLELE__;

   if (al == allele1)
      return 1;

   if (al == allele2)
      return 2;

   if (!(al == 'A' || al == 'C' || al == 'T' || al == 'G'|| al == '-'))
     return __INVALID_ALLELE__;

   if (al == 0)
     {
     allele1 = al;
     return 1;
     }

   if (allele2 == 0)
     {
     allele2 = al;
     return 2;
     }

   return __THIRD_SNP_ALLELE__;
   }


