#ifndef __ASSAYINFO_H__
#define __ASSAYINFO_H__

#include "StringArray.h"
#include "StringHash.h"
#include "QC_Settings.h"
#include "SNPInfo.h"

extern LogManager logMgr;

class AssayInfo : public QC_Settings
{
public:
   StringHash snpArray, rsArray;
   int duplicateEntries;
   int invalidAlleles;

   String failure;

   AssayInfo();
   ~AssayInfo();

   bool parseHeader(FILE * input);

   bool loadAssayInfo(FILE * input);

   SNPInfo* getSNPInfo(String & markerName);
   SNPInfo* getRSIDInfo(String & markerName);

private:
   String buffer;
   StringArray tokens;

   // array to hold the positions of the columns in the assay info file.
   // corresponds to the same order of columns as the OC_Settings 
   // file (as it is now).
   int columnPos[9];
   int numOfCols;
};

#endif
