#ifndef __FIRSTPASS_H__
#define __FIRSTPASS_H__

#include "QC_Settings.h"
#include "RelationCheck.h"
#include "StringArray.h"
#include "IntArray.h"
#include "MathVector.h"
#include "constants.h"

class FirstPass 
   {
   public:
      int markers;

      StringArray tags;

      IntArray genotypeCounts;
      IntArray heterozygoteCounts;
      IntArray sampleMendelErrors;
      IntArray qcStatus;
      IntArray mask;

      Vector sampleQualityScores;
      Vector logSexOdds;
      Vector logLikelihood;

      FirstPass();
      ~FirstPass();

      void Prepare(int individuals);
      void ProcessMarker(IntArray & genotypes);
      void BuildMask(IntArray &sex);
      void UpdateSexOdds(IntArray & genotypes, IntArray & sex, double errorRate);
      void UpdateLikelihood(IntArray & genotypes, IntArray & sex, bool isXlinked, double errorRate);
      void UpdateMendelErrors(IntArray & markerMendelErrors);
      void UpdateSampleScores(IntArray & qualityScores);
      void OutputSampleStatistics(FILE * sampleFile, StringArray & columnLables);
      void ReleaseMemory();
   };

#endif

