#ifndef __HAPMAP_REFERENCE_H__
#define __HAPMAP_REFERENCE_H__

#include "StringHash.h"
#include "IntArray.h"

#include "AssayInfo.h"

class HapMapReference
   {
   public:
      HapMapReference();
      ~HapMapReference();

      void LoadGenotypes(FILE * input, AssayInfo & assayInfo, StringArray & sampleIds);
      char * RetrieveGenotypes(String & markerName);

      void CompareGenotypes(String & markerName,
                            IntArray & genotypes, char al1, char al2, char strand,
                            IntArray & qualityScores);

      int  CustomCompare(IntArray & genos, int offset, int * genotypeMapping,
                         IntArray & detailedComparison);

      void CustomCompareByScore(IntArray & genos, IntArray & qualityScores,
                                int offset, int * genotypeMapping,
                                IntArray * detailedComparison);

      void CustomCompareBySample(IntArray & genos, IntArray & qualityScores,
                                 int offset, int * map);

      void PrintComparisonHeader();
      void PrintComparisonSummary();
      void PrintHistogram();

      void LogFlips(const char * logFilename);
      void LogSampleComparisons(const char * logFilename, StringArray & sampleIds);

      bool IsEmpty()
         { return markerLookup.Entries() == 0; }

      IntArray sampleKey, sampleComparisons, sampleDifferences;

      int different_labels, same_labels, flips, perfect;
      int tmatches, thomhom, thethom, thomhet;

      IntArray matches_by_q, homhom_by_q, hethom_by_q, homhet_by_q;

      IntArray histogram;

   private:
      char * genotypes;
      char * alleles[2];
      char * strand;
      int    overlap;

      StringIntHash markerLookup;
      StringHash    flippedMarkers, badlyLabeled;

      IntArray * comparisonByScore;
      IntArray   comparisonInterim;
   };

#endif

