#include "IgnoreSamples.h"

void IgnoreSamples::PopulateIgnoreList(FILE * input)
{
   int line = 0;
   while(!feof(input))
   {
      buffer.ReadLine(input);
      tokens.ReplaceTokens(buffer);
      line++;
      
      if (tokens.Length() == 0)   continue;
      if (tokens.Length() != 1)
      {
         failure.catprintf("WARNING: Line %d has more than 1 sample ID; Only the first ID is used.", line);
         logMgr.WriteToLog(failure, 6);
	 failure.Clear();
      }
      
      IgnoreSampleIDs.Push(tokens[0]);
   }
   isSamplePresent.Clear();
   isSamplePresent.Dimension(IgnoreSampleIDs.Length());
   isSamplePresent.Zero();
}

bool IgnoreSamples::UpdateSkipVector(String sampleID, String sampleName, Pedigree & ped)
{
   Person * person = ped.FindPerson("FORGOTTEN", sampleID);
   if (person == NULL && IgnoreSampleIDs.Find(sampleName) == -1)
   {
      IgnoreSampleIDs.Push(sampleName);
      isSamplePresent.Dimension(IgnoreSampleIDs.Length());
   }
   int index = IgnoreSampleIDs.Find(sampleName);
   if (index > -1)
   {
      isSamplePresent[index] = 1;
      isSampleSkipped.Push(1);
      return true;
   }
   else
   {
      isSampleSkipped.Push(0);
      return false;
   }
}

void IgnoreSamples::CheckIgnoreSampleIDs()
{
   if (IgnoreSampleIDs.Length() > 0 && isSamplePresent.Sum() < isSamplePresent.Length())
      logMgr.WriteToLog(String("Ignored Sample file:"), 0);

   for (int i = 0; i < IgnoreSampleIDs.Length(); i++)
      if (isSamplePresent[i] == 0)
      {
         failure.catprintf("WARNING: Sample %s in ignore list is not present in genotype file.", (const char *)IgnoreSampleIDs[i]);
	 logMgr.WriteToLog(failure, 7);
	 failure.Clear();
      }
   failure.Clear();
}
