#ifndef __IGNORESAMPLES_H__
#define __IGNORESAMPLES_H__

#include "StringArray.h"
#include "IntArray.h"
#include "Pedigree.h"
#include "LogManager.h"

extern LogManager logMgr;

class IgnoreSamples
{
public:
   StringArray IgnoreSampleIDs;
   IntArray    isSampleSkipped;
   
   IgnoreSamples(){}
   ~IgnoreSamples(){}
   
   void PopulateIgnoreList(FILE *input);
   bool UpdateSkipVector(String sampleID, String sampleName, Pedigree & ped);
   void CheckIgnoreSampleIDs();
   
private:
   String       buffer;
   StringArray  tokens;
   String       failure;
   IntArray     isSamplePresent;
};

#endif
