#include "LogManager.h"

#define MAX_LOGSIZE 2048 // in MB - thus 2 GB

LogManager::LogManager()
{
   glog = NULL;
   failCounts.Dimension(NUMFAILCODES + 1);
   failCounts.Zero();
}

void LogManager::initialize(int logFileLength)
{
   if (logFileLength <= 0)
      logFileLength = MAX_LOGSIZE;

   logSizeLimit = logFileLength*1024*1024;
   overFileSize = false;
}

bool LogManager::isOverLimit(int FailCode, bool & noMoreLogging)
{
   if (FailCode > NUMFAILCODES || FailCode < 1)
      return false;
   failCounts[FailCode]++;
   if (failCounts[FailCode] == LIMITFAILS)
      noMoreLogging = true;
   if (failCounts[FailCode] > LIMITFAILS)
      return true;
   return false;
} 

void LogManager::WriteToLog(String failure, int FailCode)
{
   if (overFileSize)  return;
   bool stopLoggingThis = false;
   
   if (glog == NULL) return;
   if (!isOverLimit(FailCode, stopLoggingThis))
      fprintf(glog, "%s\n", (const char *)failure);
   if (stopLoggingThis)
      fprintf(glog, "%d messages logged. This kind of message will no longer be logged.\n", LIMITFAILS); 
   unsigned long position = ftell(glog);
   if (position > logSizeLimit)
   {
      overFileSize = true;
      fprintf(glog, "Messages will not be logged anymore. Maximum log file size reached %ld %ld\n", position, logSizeLimit);
   }
}

