#ifndef __QCHISTOGRAMS_H__
#define __QCHISTOGRAMS_H__

#include "Parameters.h"
#include "StringArray.h"
#include "PDFChartLayout.h"
#include "PDFBarChart.h"
#include "QC_Settings.h"
#include "FirstPass.h"
#include "SampleLabel.h"
#include "constants.h"

class QCHistograms
{
private:
   StringArray MarkerTitles;
   StringArray MarkerXLabels;
   StringArray TDTTitles;
   StringArray TDTXLabels;   
   StringArray SampleTitles;
   StringArray SampleXLabels;
   StringArray RelationTitles;
   String      RelationXLabel;
   StringArray AssocTitles;
   StringArray AssocXLabels;
   
   static double red0[];
   static double red1[];
   static double green0[];
   static double green1[];
   static double blue0[];
   static double blue1[];

   void ConvertToVector(IntArray &input, Vector &output);
   void ConvertToVector(IntArray &numerator, IntArray &denomintor, Vector &output);
   void GetSampleQCStatus(IntArray &mask, IntArray &status);
   double GetColor(double z, double color0[], double color1[]);

public:
   QCHistograms()
   {
      MarkerTitles.Dimension(NUMSTATS);
      MarkerTitles[MAF] = "Marker minor allele frequency";
      MarkerTitles[COMPLETENESS] = "Marker genotyping completeness";
      MarkerTitles[HWE] = "Marker Hardy-Weinberg Equilibrium";
      MarkerTitles[MENDEL] = "Marker mendelian inconsistencies";
      MarkerTitles[MENDELRATE] = "Marker mendelian error rate";
      MarkerTitles[MISMATCHES] = "Marker duplicate mismatches";
      MarkerTitles[XODDS] = "Marker log X-linked odds";
      MarkerTitles[QUALITYSCORE] = "Marker average quality score";

      MarkerXLabels.Dimension(NUMSTATS);
      MarkerXLabels[MAF] = "Minor allele frequency";
      MarkerXLabels[COMPLETENESS] = "Genotyping completeness";
      MarkerXLabels[HWE] = "HWE p-values";
      MarkerXLabels[MENDEL] = "# of mendelian inconsistencies";
      MarkerXLabels[MENDELRATE] = "Proportion of tests failed";
      MarkerXLabels[MISMATCHES] = "# of duplicate mismatch errors";
      MarkerXLabels[XODDS] = "Log odds [Autosomal vs Xlinked]";
      MarkerXLabels[QUALITYSCORE] = "Average quality score";

      TDTTitles.Dimension(5);
      TDTTitles[0] = "TDT: Transmission of 1 allele";
      TDTTitles[1] = "TDT: Transmission of 2 allele";
      TDTTitles[2] = "TDT: Complete trios tested";
      TDTTitles[3] = "TDT: Chi-Squared statistics";
      TDTTitles[4] = "TDT: P-value of Chi-squared";

      TDTXLabels.Dimension(5);
      TDTXLabels[0] = "# of 1 alleles transmitted";
      TDTXLabels[1] = "# of 2 alleles transmitted";
      TDTXLabels[2] = "# of complete trios tested";
      TDTXLabels[3] = "Chi-Squared";
      TDTXLabels[4] = "P-value";

      SampleTitles.Dimension(6);
      SampleTitles[0] = "Sample genotyping completeness";
      SampleTitles[1] = "Sample heterozygosity";
      SampleTitles[2] = "Sample mendelian inconsistencies";
      SampleTitles[3] = "Sample Log Sex Odds";
      SampleTitles[4] = "Sample Log-Likelihood";
      SampleTitles[5] = "Sample Average Quality Score";

      SampleXLabels.Dimension(6);
      SampleXLabels[0] = "Genotyping completeness";
      SampleXLabels[1] = "Heterozygosity";
      SampleXLabels[2] = "% of inconsistent markers";
      SampleXLabels[3] = "Log Sex Odds [M vs F]";
      SampleXLabels[4] = "Log-Likelihood";
      SampleXLabels[5] = "Average Quality Score";

      RelationTitles.Dimension(5);
      RelationTitles[0] = "Unrelated pairs kinship estimates";
      RelationTitles[1] = "Half sibling pairs kinship estimates";
      RelationTitles[2] = "Sibling pairs kinship estimates";
      RelationTitles[3] = "Parent-offspring pairs kinship estimates";
      RelationTitles[4] = "Duplicate pairs kinship estimates";

      RelationXLabel = "Estimated Kinship";

      AssocTitles.Dimension(2);
      AssocTitles[0] = "Association test: Chi-squared statistics";
      AssocTitles[1] = "Association test: P-value of Chi-squared";

      AssocXLabels.Dimension(2);
      AssocXLabels[0] = "Chi-Squared";
      AssocXLabels[1] = "P-value";
   }

   ~QCHistograms(){}

   void ProcessMetric(Vector &statistic, IntArray &seriesCode, int numSeries, PDF & pdf, double min, double max, String title, String xLabel, int maxBins);
   void GetMarkerStat(StringArray &input, int column, Vector &statistic);
   bool BuildMarkerHistograms(String filename, String outputName, Vector &minimums, Vector &maximums, bool plotQuality, bool TDT, bool Assoc);
   bool BuildSampleHistograms(FirstPass &firstPass, String outputName, bool plotQuality, SampleLabel & sampLabels, IntArray & sexCodes);
   void BuildRelationHistograms(Vector &estimatedKinship, IntArray &putativeRelations, IntArray &relationError, String outputName);
   void PlotKinship(Vector &kinship, IntArray &seriesCode, PDF &pdf, String title, String xLabel);
};

#endif
