#include "QC_Settings.h"

// Genotype proportions per sample
double QC_Settings::SAMPLE_CALLS_MIN     = 0.95;
double QC_Settings::SAMPLE_CALLS_ZSCORE  = 5;

// Heterozygosities per sample
double QC_Settings::SAMPLE_HET_MIN       = 0.10;
double QC_Settings::SAMPLE_HET_MAX       = 0.40;
double QC_Settings::SAMPLE_HET_ZSCORE    = 5;

// SexOdds and LogL thresholds
double QC_Settings::SAMPLE_LOGL          = -100.0;
double QC_Settings::SAMPLE_LSEXODDS      = 10.0;

// Mendelian error rates per sample
double QC_Settings::SAMPLE_MENDEL_MAX    = 0.02;

// Sample property label name
String QC_Settings::SAMPLE_LABEL_KEY     = "";
 
// genotyping error rates
double QC_Settings::GENOTYPING_ERROR     = 0.01;


// marker thresholds
double QC_Settings::MARKER_CALLS_MIN      = 0.95;
int    QC_Settings::MARKER_MISMATCHES_MAX = 1;
double QC_Settings::MARKER_HWE_PVALUE     = 1e-6;
double QC_Settings::MARKER_MENDEL_RATE    = 0.01;
int    QC_Settings::MARKER_MAX_MENDEL     = 5;

//output control histograms
int    QC_Settings::SAMPLE_PDF_MAX_BINS   = 100;
int    QC_Settings::SAMPLE_TXT_MAX_BINS   = 10;
int    QC_Settings::MARKER_PDF_MAX_BINS   = 100;
int    QC_Settings::MARKER_TXT_MAX_BINS   = 10;
  

// quality score thresholds
double QC_Settings::QUALITY_THRESHOLD = 0;

// relation check thresholds
double QC_Settings::RELATION_ZSCORE = 5;
double QC_Settings::RELATION_MAF_MIN  = 0.1;
double QC_Settings::RELATION_MAX_MEAN_DIFF = 0.1;
int    QC_Settings::RELATION_BINS = 100;

// minimum minor allele thresholds
double QC_Settings::MAF_MIN = 0;
int    QC_Settings::MIN_ALLELE_COUNT = 0;    

//Assay info file header/coulumn names
String QC_Settings::PREFERRED_ID = "PREFERRED_ID";
String QC_Settings::RS_ID        = "RS_ID";
String QC_Settings::BUILD        = "BUILD";
String QC_Settings::CHR          = "CHR";
String QC_Settings::POSITION     = "POSITION";
String QC_Settings::QC_TYPE      = "QC_TYPE";
String QC_Settings::SEQUENCE     = "SEQUENCE";
String QC_Settings::SOURCE       = "SOURCE";
String QC_Settings::STRAND       = "STRAND";


void QC_Settings::SetDefaults()
{
   custom.AddSetting("SAMPLE_CALLS_MIN", SAMPLE_CALLS_MIN);
   custom.AddSetting("SAMPLE_CALLS_ZSCORE", SAMPLE_CALLS_ZSCORE);
   custom.AddSetting("SAMPLE_HET_MIN", SAMPLE_HET_MIN);
   custom.AddSetting("SAMPLE_HET_MAX", SAMPLE_HET_MAX);
   custom.AddSetting("SAMPLE_HET_ZSCORE", SAMPLE_HET_ZSCORE);
//   custom.AddSetting("SAMPLE_LOGL", SAMPLE_LOGL);
   custom.AddSetting("SAMPLE_LSEXODDS", SAMPLE_LSEXODDS);
   custom.AddSetting("SAMPLE_MENDEL_MAX", SAMPLE_MENDEL_MAX);
   custom.AddSetting("SAMPLE_LABEL_KEY", SAMPLE_LABEL_KEY);
   custom.AddSetting("GENOTYPING_ERROR", GENOTYPING_ERROR);
   custom.AddSetting("MARKER_CALLS_MIN", MARKER_CALLS_MIN);
   custom.AddSetting("MARKER_MISMATCHES_MAX", MARKER_MISMATCHES_MAX);
   custom.AddSetting("MARKER_HWE_PVALUE", MARKER_HWE_PVALUE);
   custom.AddSetting("MARKER_MENDEL_RATE", MARKER_MENDEL_RATE);
   custom.AddSetting("MARKER_MAX_MENDEL", MARKER_MAX_MENDEL);
   custom.AddSetting("PREFERRED_ID", PREFERRED_ID);
   custom.AddSetting("RS_ID", RS_ID);
   custom.AddSetting("BUILD", BUILD);
   custom.AddSetting("CHR", CHR);
   custom.AddSetting("POSITION", POSITION);
   custom.AddSetting("QC_TYPE", QC_TYPE);
   custom.AddSetting("SEQUENCE", SEQUENCE);
   custom.AddSetting("SOURCE", SOURCE);
   custom.AddSetting("STRAND", STRAND);
   custom.AddSetting("QUALITY_THRESHOLD", QUALITY_THRESHOLD);
   custom.AddSetting("RELATION_ZSCORE", RELATION_ZSCORE);
   custom.AddSetting("RELATION_MAF_MIN", RELATION_MAF_MIN);
   custom.AddSetting("RELATION_MAX_MEAN_DIFF", RELATION_MAX_MEAN_DIFF);
   custom.AddSetting("RELATION_BINS", RELATION_BINS);
   custom.AddSetting("MIN_MAF", MAF_MIN);
   custom.AddSetting("MIN_ALLELE_COUNT", MIN_ALLELE_COUNT);
   custom.AddSetting("SAMPLE_PDF_MAX_BINS", SAMPLE_PDF_MAX_BINS);
   custom.AddSetting("SAMPLE_TXT_MAX_BINS", SAMPLE_TXT_MAX_BINS);
   custom.AddSetting("MARKER_PDF_MAX_BINS", MARKER_PDF_MAX_BINS);
   custom.AddSetting("MARKER_TXT_MAX_BINS", MARKER_TXT_MAX_BINS);
//   custom.AddSetting("", );
}
