#ifndef __QCSETTINGS_H__
#define __QCSETTINGS_H__

#include "StringBasics.h"
#include "CustomSettings.h"

class QC_Settings
   {
   public:
      // Genotype proportions per sample
      static double SAMPLE_CALLS_MIN;
      static double SAMPLE_CALLS_ZSCORE;

      // Heterozygosities per sample
      static double SAMPLE_HET_MIN;
      static double SAMPLE_HET_MAX;
      static double SAMPLE_HET_ZSCORE;

      // Sex Odds thresholds and logL thresholds
      static double SAMPLE_LOGL;
      static double SAMPLE_LSEXODDS;
      
      // Mendel error rates per sample
      static double SAMPLE_MENDEL_MAX;
      
      // Sample property label name
      static String SAMPLE_LABEL_KEY;

      // Genotyping error rate
      static double GENOTYPING_ERROR;

      // marker thresholds
      static double MARKER_CALLS_MIN;
      static int    MARKER_MISMATCHES_MAX;
      static double MARKER_HWE_PVALUE;
      static double MARKER_MENDEL_RATE;
      static int    MARKER_MAX_MENDEL;
      
      //output control histograms
      static int    SAMPLE_PDF_MAX_BINS;
      static int    SAMPLE_TXT_MAX_BINS;
      static int    MARKER_PDF_MAX_BINS;
      static int    MARKER_TXT_MAX_BINS;
      
      // quality thresholds
      static double QUALITY_THRESHOLD;

      // relation check thresholds
      static double RELATION_ZSCORE;
      static double RELATION_MAF_MIN;
      static double RELATION_MAX_MEAN_DIFF;
      static int    RELATION_BINS;
      
      // minimum allele thresholds
      static double MAF_MIN;
      static int    MIN_ALLELE_COUNT;

      //Assay Info header column names
      static String PREFERRED_ID;
      static String RS_ID;
      static String BUILD;
      static String CHR;
      static String POSITION;
      static String QC_TYPE;
      static String SEQUENCE;
      static String SOURCE;
      static String STRAND;

      CustomSettings custom;

      void SetDefaults();
   };

#endif


