#ifndef __QUALITY_H__
#define __QUALITY_H__

#include "StringHash.h"
#include "StringArray.h"
#include "IntArray.h"
#include "LogManager.h"

extern LogManager logMgr;

class Quality
{
public:
   StringHash  markerLine;

   Quality();

   String      failure;

   double      avgQualityScorePreThreshold;

   IntArray    sampleColumn;
   
   bool        LoadHeader(FILE * qualityFile, StringArray & genoFileSampleIds);
   bool        CheckQualityScores(String & markerName, IntArray & genotypes, FILE * qualityFile, bool &noGenoPostQual);

   void        PopulateMarkerHash(FILE * qualityFile);
   void        LoadQualityScores(FILE * qualityFile, String & markerName, IntArray & scores);

private:
   String      buffer;
   StringArray tokens;

   int         headerColumns;
   int         genotypeCount;   
};

#endif
