#ifndef __RELCHECK_H__
#define __RELCHECK_H__

#include "MathVector.h"
#include "MathGenMin.h"
#include "IntArray.h"
#include "StringArray.h"
#include <cmath>

#define UNRELATED		1
#define HALF_SIBS		2
#define SIBLINGS		3
#define PARENT_OFFSPRING 	4
#define DUPLICATES		5  /* also stands for MZ twins */
#define RELATED 		6  /* related somehow, more than unrelated but less than half-sibs */

class RelationCheck
{
public:
  IntArray putativeRelations;
  IntArray estimatedRelations;
  IntArray relationError;
  
  Vector estimatedKinship;

  RelationCheck(){}
  RelationCheck(int numSamples);
  ~RelationCheck();

  void updateRelMatrices(IntArray & genotypes, IntArray & mask);
  void findIBDProbs(int pairIndex);
  void ReleaseMemory();
  void outputRelFile(FILE* rel, int pairIndex);
  void initRelations(IntArray &fatherColumn, IntArray &motherColumn, IntArray &columnToSampleId, int numSamples);
  void checkRelationships();
  void outputRelationInfo(FILE *relFile, StringArray &sampleNames);

protected:
  Vector exp_IBS0_IBD0, exp_IBS1_IBD0, exp_IBS1_IBD1;
  Vector observed_IBS0, observed_IBS1, observed_IBS2;

private:
  Vector meanKinship;
  Vector sdKinship;
  Vector zscore;

  double expectedIBDProbs[5][3];
  double expectedKinship[5];

  StringArray relationNames;
  
  double maxDelta;
  
  int calculateEstimatedRelationship(double ibd0, double ibd1, double ibd2);
};


class RelationSolver
{
public:
  RelationSolver(double exp_IBS0_IBD0, double exp_IBS1_IBD0,
             double exp_IBS1_IBD1, double obs_IBS0,
             double obs_IBS1, double obs_IBS2);
  void   RunEMIterations();
  double ibd[3];
private:
  double expected_IBS0_IBD0, expected_IBS1_IBD0, expected_IBS1_IBD1;
  double expected_IBS2_IBD0, expected_IBS2_IBD1, expected_IBS2_IBD2;
  double observed_IBS0, observed_IBS1, observed_IBS2;
  double N;
  double tolerance;
};
#endif
