#include "ResultFileOutput.h"

void ResultOutputter::WriteOutputHeader(FILE * outFile, IntArray & mask, StringArray & columnLabels)
{
   fprintf(outFile, "%s", (const char *)columnLabels[0]);
   for (int i = 1; i < columnLabels.Length(); i++)
      if (mask[i] == 0)
         fprintf(outFile, "\t%s", (const char *)columnLabels[i]);
   fprintf(outFile, "\n");
}

void ResultOutputter::WriteQualityScoreLine(FILE * outQualityFile, IntArray & mask, IntArray & qualityScores, String markerName)
{
   fprintf(outQualityFile, "%s", (const char *)markerName);
   for (int i = 1; i < qualityScores.Length(); i++)
      if (mask[i] == 0)
         fprintf(outQualityFile, "\t%d", qualityScores[i]);
   fprintf(outQualityFile, "\n");
}

void ResultOutputter::WriteGenotypeLine(FILE * outGenoFile, IntArray & mask, IntArray & genotypes, String markerName, char* alleles)
{
   char genotypeSymbols[4][3];
   genotypeSymbols[0][0] = genotypeSymbols[0][1] = 'N', genotypeSymbols[0][2] = '\0';
   genotypeSymbols[1][0] = genotypeSymbols[1][1] = alleles[0], genotypeSymbols[1][2] = '\0';
   genotypeSymbols[2][0] = genotypeSymbols[2][1] = alleles[1], genotypeSymbols[2][2] = '\0';
   genotypeSymbols[3][0] = alleles[0], genotypeSymbols[3][1] = alleles[1], genotypeSymbols[3][2] = '\0';   
   
   fprintf(outGenoFile, "%s", (const char *)markerName);
   for (int i = 1; i < genotypes.Length(); i++)
      if (mask[i] == 0)
         fprintf(outGenoFile, "\t%s", genotypeSymbols[genotypes[i]]);
   fprintf(outGenoFile, "\n");
}
