#include "SNPInfo.h"
#include <ctype.h>
#define MINSEQLENGTH 15

SNPInfo::SNPInfo()
{
   alleles[0] = alleles[1] = 0;
}

SNPInfo::~SNPInfo()
{
}

bool SNPInfo::FindAlleles()
{
   String failure = "";
   String bases = "ACTG-";

        int openbracket = sequence.FindChar('[');
        int closebracket = sequence.FindChar(']');
        int separator = sequence.FindChar('/');

        if (openbracket < 0 || closebracket < 0 || separator < 0 ||
            openbracket + 2 != separator || separator + 2 != closebracket ||
            bases.FindChar(sequence[openbracket + 1]) < 0 ||
            bases.FindChar(sequence[separator + 1]) < 0)
           {
           failure.catprintf("INVALID FORMAT: Could not decode SNP sequence for %s", (const char *) preferredID);
	   logMgr.WriteToLog(failure, 1);
	   failure.Clear();
           return false;
           }

   alleles[0] = toupper(sequence[openbracket+1]);
   alleles[1] = toupper(sequence[closebracket-1]);

   if (openbracket < (MINSEQLENGTH+2) || sequence.Length() - closebracket < (MINSEQLENGTH+2))
   {
      failure.catprintf("WARNING: SNP %s has very short flanking sequences", (const char *)preferredID);
      logMgr.WriteToLog(failure, 2);
      failure.Clear();
   }
   
   return true;
}

bool SNPInfo::AreAllelesSwitched(char * loaderAlleles, bool monomorphic)
{
   String snpFileAlleles;
   snpFileAlleles.Dimension(2);
   snpFileAlleles[0] = alleles[0], snpFileAlleles[1] = alleles[1];

   if (!snpFileAlleles.FastCompare("AT") || !snpFileAlleles.FastCompare("TA") ||
      !snpFileAlleles.FastCompare("CG") || !snpFileAlleles.FastCompare("GC"))
   {
      return false;
   }
   if (monomorphic)
   {
      String intermediate = switchBases(alleles);
      return (intermediate.FindChar(loaderAlleles[0],0) >= 0);
   }

   String genoFileAlleles = switchBases(loaderAlleles);
   if(!genoFileAlleles.FastCompare(snpFileAlleles) ||
      !genoFileAlleles.FastCompare(snpFileAlleles.RightToLeft()))
      return true;
   return false;
}

String SNPInfo::switchBases(char * loaderAlleles)
{
   char temp[2];
   for (int i = 0; i < 2; i++)
   {
      switch(loaderAlleles[i])
      {
         case 'a':
         case 'A': temp[i] = 'T';
                 break;
         case 't':
         case 'T': temp[i] = 'A';
                 break;
         case 'g':
         case 'G': temp[i] = 'C';
                 break;
         case 'c':
         case 'C': temp[i] = 'G';
                 break;
         default : temp[i] = loaderAlleles[i];
      }
   }
   String temp2;
   temp2.Dimension(2);
   temp2[0] = temp[0], temp2[1] = temp[1];
   return temp2;
}


bool SNPInfo::DoAllelesMatch(char * loaderAlleles, bool monomorphic)
{
   String snpFileAlleles;
   snpFileAlleles.Dimension(2);
   snpFileAlleles[0] = alleles[0], snpFileAlleles[1] = alleles[1];

   if(monomorphic)
      return (snpFileAlleles.FindChar(loaderAlleles[0],0) >= 0);

   return (snpFileAlleles.FindChar(toupper(loaderAlleles[0]),0) >= 0) &&
          (snpFileAlleles.FindChar(toupper(loaderAlleles[1]),0) >= 0);
}
